% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics_filter.R
\name{conditions}
\alias{conditions}
\title{Define metric conditions}
\usage{
conditions(...)
}
\arguments{
\item{...}{Patch or metric conditions in the form of lists. See Details.}
}
\value{
A list to be inputted within the argument \code{patch_conditions} in \code{\link[=generate_points]{generate_points()}} or
the argument \code{conditions} in \code{\link[=metrics_filter]{metrics_filter()}}.
}
\description{
Helper function to define patch conditions within \code{\link[=generate_points]{generate_points()}} or
metric conditions within \code{\link[=metrics_filter]{metrics_filter()}}.
}
\details{
Conditions must be defined as lists (one or more).

For patch conditions, within
the environment of \code{\link[=generate_points]{generate_points()}}, each element within the list defines the condition
that the patch must meet in relation to the value of certain patch-level metric, as follows:

\preformatted{
 list(class, metric, minimum value, maximum value)
}
\itemize{
\item class: the class (raster value) of the patch that must meet the defined conditions. More than one class can
be specified.
\item metric: the patch-level metric whose values must meet the defined conditions. Only one metric
per condition can be defined. Available patch-level metrics can be found in \code{\link[=metrics_list]{metrics_list()}} and in
documentation of the package \code{landscapemetrics}.
\item minimum value: the minimum value that the metric must have for the retained patches. If equal
to -Inf, and a maximum value is defined, patches whose values in the defined metric are equal
or lower to the maximum value will be retained.
\item maximum value: the maximum value that the metric must have in the retained patches. If equal
to Inf, and a minimum value is defined, patches whose values in the defined metric are equal
or higher to the minimum value will be retained.
}

For metric conditions, within
the environment of \code{\link[=metrics_filter]{metrics_filter()}}, each element within the list defines the required
metric conditions, as follows:

\preformatted{
 list(rasterlayers, class, radii, metric, minimum value, maximum value)
}
\itemize{
\item rasterlayers: the raster layers to be considered. If NA, all raster layers will be considered. If
an extra raster layer must be specified, the string "ext" must precede the raster layer number
(e.g. "ext1", "ext2").
\item class: the classes to be considered, as numbers or strings with the names of the classes. If NA, all classes of required raster layers will be
considered. If NULL, the function will assume that the metric to be considered is a landscape-level metric.
Take into account that metrics from extra calculations are considered as landscape-level metrics.
\item radii: the radii to be considered. If NA, all radii will be considered.
\item metrics: the name of the metric to be considered (as defined with its abbreviation by column "metric" in \code{\link[=metrics_list]{metrics_list()}}).
Only one metric per condition can be defined. Metrics as extra calculations for extra raster layers must be
provided as "fun_" + the name of the function (e.g. "fun_mean").
\item minimum value: the minimum value that the metric must have in the filtered landscapes. If equal
to -Inf, and a maximum value is defined, landscapes whose values in the defined metric are equal
or lower to the maximum value will be retained.
\item maximum value: the maximum value that the metric must have in the filtered landscapes. If equal
to Inf, and a minimum value is defined, landscapes whose values in the defined metric are equal
or higher to the minimum value will be retained.
}

See the example sections of functions \code{\link[=generate_points]{generate_points()}} and
\code{\link[=metrics_filter]{metrics_filter()}} for more details.
}
