% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mland_export_gis.R
\name{mland_export_gis}
\alias{mland_export_gis}
\title{Exports a 'MultiLand' object as GIS data}
\usage{
mland_export_gis(
  x,
  raster = NULL,
  points = NULL,
  radii = NULL,
  ext_raster = NULL,
  name = NULL,
  gdal = c("COMPRESS=DEFLATE", "PREDICTOR=2", "ZLEVEL=9"),
  dir = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{x}{An object of class 'MultiLand' generated with \code{\link[=mland]{mland()}}.}

\item{raster, ext_raster}{Numeric. The raster layers to be exported.}

\item{points}{Numeric or character vector of points to be processed. See Details.}

\item{radii}{Numeric vector of radii to be processed.}

\item{name}{Character. Name of the zip file where files will be exported.}

\item{gdal}{GeoTiff creation options for rasters (\href{https://gdal.org/en/stable/drivers/raster/gtiff.html}{GeoTiff file format}).
\code{\link[=mland_export_gis]{mland_export_gis()}} uses the following compression options:
c("COMPRESS=DEFLATE", "PREDICTOR=2", "ZLEVEL=9").}

\item{dir}{Path to the export directory. This must be specified explicitly.
To export to the current directory, use \code{dir = getwd()}. Otherwise, provide
a valid path to an existing directory, ensuring it does not end with "/".}

\item{verbose}{Print messages in the console? Default is TRUE.}

\item{...}{Other arguments passed to \link[terra:writeRaster]{terra::writeRaster}.}
}
\value{
GIS data from a 'MultiLand' object is exported through a zip file.
}
\description{
Exports points, buffers and intersections between buffers and raster layers, as vector and raster
files.
}
\details{
If argument \code{points} is a character vector,
\code{\link[=mland_export_gis]{mland_export_gis()}} will assume that the 'MultiLand' object inputted in argument \code{x} was created with
\code{site_ref = TRUE}. This is, there is an attribute in points layer data with the names for
each individual point. Therefore, the inputted values in argument \code{points} will be taken as these
identification names. Otherwise, if a numeric vector is declared, the inputted values
will be taken as the automatically generated point ids (created when running \code{\link[=mland]{mland()}}).
}
\examples{
\donttest{
# Loads a 'MultiLand' object
ernesdesign <- system.file("extdata", "ernesdesign.zip", package = "multilandr")
ernesdesign <- mland_load(ernesdesign)

# Exports as GIS data, in temporary directory for this example and with a given name
mland_export_gis(ernesdesign, dir = tempdir(), name = "mland-GIS_example")

# Remove file for this example
unlink(file.path(tempdir(), "mland-GIS_example.zip"))
}
}
\seealso{
\code{\link[=mland]{mland()}}, \code{\link[=mland_save]{mland_save()}}, \code{\link[=mland_load]{mland_load()}}
}
