% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mland_overlap.R
\name{mland_overlap}
\alias{mland_overlap}
\title{Buffers overlapping}
\usage{
mland_overlap(
  x,
  points = NULL,
  radii = NULL,
  digits = 2,
  perc = TRUE,
  title = "id"
)
}
\arguments{
\item{x}{An object of class 'Multiland' generated with \code{\link[=mland]{mland()}}.}

\item{points}{Numeric or character vector depicting the points to be considered. If NULL, all
points will be taken into account. See Details.}

\item{radii}{Numeric vector depicting the radii to be considered. If NULL, all radii will be taken
into account.}

\item{digits}{Numeric. Number of digits for the values of overlapped areas. Default is 2.}

\item{perc}{Logical. If TRUE (default) the degree of overlapped areas will be
presented as percentages. If FALSE, proportions will be outputted.}

\item{title}{One of the following: "id" to output each point with its id (default), or "sitename" to
output each point with its pre-defined point name in \code{x}.}
}
\value{
A list with as many elements as different radius in \code{x}. Each element contains a
matrix with the percentages (or proportions if \code{perc = FALSE}) of overlapping of buffer areas.
}
\description{
Returns matrices informing the degree of overlapped area
between buffers of a 'MultiLand' object.
}
\details{
If argument \code{points} is a character vector,
\code{\link[=mland_overlap]{mland_overlap()}} will assume that the 'MultiLand' object inputted in argument \code{x} was created with
\code{site_ref = TRUE}. This is, there is a column/attribute in the points layer with the names for
each distinct point. Therefore, the inputted values in argument \code{points} will be taken as these
identification names. Otherwise, if a numeric vector is declared, the inputted values
will be taken as the automatically generated point ids (created when executing \code{\link[=mland]{mland()}}).
}
\examples{
\donttest{
# Loads a 'MultiLand' object
ernesdesign <- system.file("extdata", "ernesdesign.zip", package = "multilandr")
ernesdesign <- mland_load(ernesdesign)

# Returns a matrix with the percentage of overlapping between buffers of each radii
mland_overlap(ernesdesign)

# Selects only one radius and return the site names rather than the ids
mland_overlap(ernesdesign, radii = 5000, title = "sitename")
}
}
