% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity.R
\name{sensitivity_pathwise}
\alias{sensitivity_pathwise}
\title{Sensitivity Analysis for Pathwise Indirect Effects}
\usage{
sensitivity_pathwise(
  model,
  exper,
  confound_ix = NULL,
  rho_seq = NULL,
  n_bootstrap = 100,
  progress = TRUE,
  ...
)
}
\arguments{
\item{model}{A \code{multimedia} object containing the fitted models for
sensitivity analysis. Note that since our approach relies on correlating
simulated residual error, it is only applicable to models of class
\code{lm_model()}, \code{glmnet_model()} and \code{rf_model()}.}

\item{exper}{The original \code{mediation_data} class object used to fit \code{model}.
These observations will be resampled to support bootstrap confidence
interval construction of the sensitivity curve.}

\item{confound_ix}{A data.frame specifying which mediator/outcome should
be allowed to be correlated. Should have two columns: 'mediator' and
'outcome' specifying which pairs of mediators and outcomes should be
correlated. Defaults to NULL, which creates a data.frame with no rows (and
so enforcing independence between mediators and outcomes)}

\item{rho_seq}{We will evaluate correlations Cor(e', e) between mediation and
outcome model errors ranging along this grid. Defaults to NULL, which
internally sets the sequence to rho = (-0.9, -0.7 ..., 0.7, 0.9).}

\item{n_bootstrap}{The number of bootstrap resamples used to build confidence
bands around the sensitivity curves. Defaults to 100.}

\item{progress}{A logical indicating whether to show a progress bar.}

\item{...}{Additional arguments passed to indirect_pathwise.}
}
\value{
A \code{date.frame} giving the outputs of \code{indirect_overall} across many
values of the correlation rho.
}
\description{
For causal identification, mediation analysis relies on several untestable
assumptions. One important one is that there is no confounding between the
counterfactual mediator and outcome variables. Even though we can never know
whether this exists, we can measure the sensitivity of our conclusions to the
existence/strength of such a confounder. In this function, we approach this
by inducing (unallowable) correlation between the mediator and outcome model
residuals, simulate forward, and see how the estimated pathwise indirect
effects change.
}
\examples{
xy_data <- demo_spline()
exper <- mediation_data(
    xy_data, starts_with("outcome"), "treatment", "mediator"
)
model <- multimedia(
    exper,
    outcome_estimator = glmnet_model(lambda = 1e-2)
) |>
    estimate(exper)
rho_seq <- c(-0.2, 0, 0.2)
subset_indices <- expand.grid(
    mediator = n_mediators(model), outcome = n_outcomes(model)
)
sensitivity_pathwise(model, exper, subset_indices, rho_seq, n_bootstrap = 2)
}
