% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoway_projector.R
\name{cross_projector}
\alias{cross_projector}
\title{Two-way (cross) projection to latent components}
\usage{
cross_projector(
  vx,
  vy,
  preproc_x = prep(pass()),
  preproc_y = prep(pass()),
  ...,
  classes = NULL
)
}
\arguments{
\item{vx}{the X coefficients. Must have the same number of columns as \code{vy}.}

\item{vy}{the Y coefficients. Must have the same number of columns as \code{vx}.}

\item{preproc_x}{the X pre-processor}

\item{preproc_y}{the Y pre-processor}

\item{...}{extra parameters or results to store}

\item{classes}{additional class names}
}
\value{
a cross_projector object
}
\description{
A projector that reduces two blocks of data, X and Y, yielding a pair of weights for each component.
This structure can be used, for example, to store weights derived from canonical correlation analysis.
}
\details{
This class extends \code{projector} and therefore basic operations such as \code{project}, \code{shape}, \code{reprocess},
and \code{coef} work, but by default, it is assumed that the \code{X} block is primary. To access \code{Y} block operations, an
additional argument \code{source} must be supplied to the relevant functions, e.g., \code{coef(fit, source = "Y")}
}
\examples{
# Create two scaled matrices X and Y
X <- scale(matrix(rnorm(10 * 5), 10, 5))
Y <- scale(matrix(rnorm(10 * 5), 10, 5))

# Perform canonical correlation analysis on X and Y
cres <- cancor(X, Y)
sx <- X \%*\% cres$xcoef
sy <- Y \%*\% cres$ycoef

# Create a cross_projector object using the canonical correlation analysis results
canfit <- cross_projector(cres$xcoef, cres$ycoef, cor = cres$cor,
                          sx = sx, sy = sy, classes = "cancor")
}
