% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fpunique.R
\name{fpmod}
\alias{fpmod}
\title{Modulo division with rounding}
\usage{
fpmod(set, edo = 12, rounder = 10)
}
\arguments{
\item{set}{Numeric vector of pitch-classes in the set}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}

\item{rounder}{Numeric (expected integer), defaults to \code{10}:
number of decimal places to round to when testing for equality.}
}
\value{
Numeric vector the same length as \code{set}
}
\description{
When working with sets in continuous pitch-class spaces (i.e., where
octave equivalence is needed), R's normal operator for modulo division
\code{\%\%} does not always give ideal results. Values that are very close to
(but below) the octave appear to be far from 0. This function uses
rounding to give octave-equivalent results that music theorists expect.
}
\examples{
really_small <- 1e-13
c_major <- c(0, 4, 7, 12-really_small)
c_major \%\% 12
fpmod(c_major, 12)

}
