% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals_and_scales.R
\name{j}
\alias{j}
\title{Convenient just-intonation intervals and scales}
\usage{
j(..., edo = 12)
}
\arguments{
\item{...}{One or more names that will be matched to just intervals. You can
enter these as strings, but for convenience sake you needn't. Here are the
currently accepted inputs, their meaning, and their return value:
\itemize{
\item \code{1}: perfect 1th (0 semitones)
\item \code{u}: unison (0 semitones)
\item \code{synt}: syntonic comma (~.215 semitones)
\item \code{pyth}: Pythagorean comma (~.235 semitones)
\item \code{l}: Pythagorean limma (256:243 or ~.9 semitones)
\item \code{s}: 5-limit just semitone (16:15 or ~1.12 semitones)
\item \code{st}: 5-limit just semitone (16:15 or ~1.12 semitones)
\item \code{m2}: 5-limit minor second (16:15 or ~1.12 semitones)
\item \code{h}: half step (16:15 or ~1.12 semitones)
\item \code{a}: Pythagorean apotome (2187:2048 or ~1.14 semitones)
\item \code{mt}: 5-limit minor tone (10:9 or ~1.82 semitones)
\item \code{2}: 3-limit major second (9:8 or ~2.04 semitones)
\item \code{t}: 3-limit whole tone (9:8 or ~2.04 semitones)
\item \code{w}: whole tone (9:8 or ~2.04 semitones)
\item \code{wt}: whole tone (9:8 or ~2.04 semitones)
\item \code{sept}: 7-limit (septimal) whole tone (8:7 or ~2.31 semitones)
\item \code{sdt}: 3-limit semiditone (32/27 or ~2.94 semitones)
\item \code{pm3}: Pythagorean minor third (32/27 or ~2.94 semitones)
\item \code{m3}: 5-limit minor third (6:5 or ~3.16 semitones)
\item \code{3}: 5-limit major third (5:4 or ~3.86 semitones)
\item \code{M3}: 5-limit major third (5:4 or ~3.86 semitones)
\item \code{dt}: 3-limit ditone (81/64 or ~4.08 semitones)
\item \code{4}: 3-limit perfect fourth (4:3 or ~4.98 semitones)
\item \code{utt}: 11-limit tritone (11:8 or ~5.51 semitones)
\item \code{stt}: 7-limit tritone (7:5 or ~5.83 semitones)
\item \code{jtt}: 5-limit tritone (45:32 or ~5.90 semitones)
\item \code{ptt}: 3-limit tritone (729:512 or ~6.12 semitones)
\item \code{pd5}: 3-limit diminished fifth (1024/729 or ~5.88 semitones)
\item \code{5}: 3-limit perfect fifth (3:2 or ~7.02 semitones)
\item \code{m6}: 5-limit minor sixth (8:5 or ~8.14 semitones)
\item \code{6}: 5-limit major sixth (5:3 or ~8.84 semitones)
\item \code{pm7}: Pythagorean minor seventh (16:9 or ~9.96 semitones)
\item \code{m7}: 5-limit minor seventh (9:5 or ~10.18 semitones)
\item \code{7}: 5-limit major seventh (15:8 or ~10.88 semitones)
\item \code{8}: 2-limit perfect octave (2:1 or 12 semitones)
\item \code{dia}: the complete 5-limit diatonic scale
}}

\item{edo}{Number of unit steps in an octave. Defaults to \code{12}.}
}
\value{
Numeric vector representing the input just intervals converted to \code{edo} unit steps per octave
}
\description{
It's not hard to define a just interval from a frequency ratio: it only
requires an input like \code{12*log2(freq_ratio)}. That gets pretty tiresome
if you're doing this a lot, though, so for convenience \code{musicMCT} includes a \code{j()}
function (not related to \href{https://www.jstor.org/stable/843811}{Clough and Douthett's J function}
but it wishes it was). \code{j()} is designed to behave a lot like base R's \code{\link[=c]{c()}}
in the way that you'd use it to define a scale (see the examples below).
The inputs that this can take are limited and hard-coded, since there's no
systematic way to define short hands for every potential just interval.
In general, the logic is that individual digits refer to major intervals up from
the tonic in the 5-limit just diatonic scale. The prefix "m" to a number (e.g. "m3")
gives the equivalent minor version of the interval. If you
just want the entire 5-limit diatonic, you can enter \code{dia}.
}
\examples{
major_triad <- j(1,3,5)
isTRUE(all.equal(major_triad, j(u, M3, "5")))

isTRUE(all.equal(j(dia), j(1,2,3,4,5,6,7)))

# How far is the twelve-equal major scale from the 5-limit just diatonic?
dist(rbind(c(0,2,4,5,7,9,11), j(dia)))

# Is 53-equal temperament a good approximation of the 5-limit just diatonic?
j(dia, edo=53)

}
\seealso{
\code{\link[=z]{z()}} as a shortcut for 12*log2(x) when a just interval you need isn't
defined for \code{j()}.
}
