plot.mvout <-
  function(x, outcol = "red", incol = "black", outpch = 0, inpch = 1,
           xlab = "PC1", ylab = "PC2", xresign = FALSE, yresign = FALSE, ...){
    # plot method for mvout objects
    # Jesus E. Delgado and Nathaniel E. Helwig
    # updated: 2024 Dec 11
    
    
    scores <- x$scores
    
    if(is.null(scores)){
      
      if(x$args$standardize){
        xcent <- scale(x$args$x, center = x$mcd$center, scale = sqrt(diag(x$mcd$cov)))
        cmat <- cov2cor(x$mcd$cov)
      } else {
        xcent <- scale(x$args$x, center = x$mcd$center, scale = FALSE)
        cmat <- x$mcd$cov
      }
      reig <- eigen(cmat, symmetric = TRUE)
      loadings <- reig$vectors[,1:2]
      lsigns <- sign(colSums(loadings^3))
      if(any(lsigns == 0)) lsigns[lsigns == 0] <- 1
      loadings <- loadings %*% diag(lsigns)
      scores <- xcent %*% loadings %*% diag(1/sqrt(reig$values[1:2]))
      
    }  else {
      
      if(ncol(scores) < 2L) {
        scores <- cbind(1:nrow(scores), scores)
        ylab <- xlab
        xlab <- "Index"
      }
      
    }
    
    if(xresign) scores[,1] <- 0 - scores[,1]
    if(yresign) scores[,2] <- 0 - scores[,2]
    plot(scores,
         col = ifelse(x$outlier, outcol, incol),
         pch = ifelse(x$outlier, outpch, inpch),
         xlab = xlab,
         ylab = ylab,
         ...)

  } # end plot.mvout
