% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myrror-package.R, R/myrror.R
\docType{package}
\name{myrror}
\alias{myrror-package}
\alias{myrror}
\title{myrror: Compare Data Frames}
\usage{
myrror(
  dfx,
  dfy,
  by = NULL,
  by.x = NULL,
  by.y = NULL,
  compare_type = TRUE,
  compare_values = TRUE,
  extract_diff_values = TRUE,
  factor_to_char = TRUE,
  interactive = getOption("myrror.interactive"),
  verbose = getOption("myrror.verbose"),
  tolerance = getOption("myrror.tolerance")
)
}
\arguments{
\item{dfx}{a non-empty data.frame.}

\item{dfy}{a non-empty data.frame.}

\item{by}{character, key to be used for dfx and dfy.}

\item{by.x}{character, key to be used for dfx.}

\item{by.y}{character, key to be used for dfy.}

\item{compare_type}{TRUE or FALSE, default to TRUE.}

\item{compare_values}{TRUE or FALSE, default to TRUE.}

\item{extract_diff_values}{TRUE or FALSE, default to TRUE.}

\item{factor_to_char}{TRUE or FALSE, default to TRUE.}

\item{interactive}{logical: If \code{TRUE}, print S3 method for myrror objects
displays by chunks. If \code{FALSE}, everything will be printed at once.}

\item{verbose}{logical: If \code{TRUE}, print messages.}

\item{tolerance}{numeric, default to 1e-7.}
}
\value{
Object of class "myrror" containing:
\itemize{
\item \code{name_dfx}, \code{name_dfy}: Names of input data frames
\item \code{prepared_dfx}, \code{prepared_dfy}: Prepared versions of input data frames
\item \code{set_by.x}, \code{set_by.y}: Keys used for comparison
\item \code{datasets_report}: Characteristics of input datasets (rows, columns)
\item \code{match_type}: Type of join relationship ("1:1", "1:m", "m:1")
\item \code{merged_data_report}: Information about matched and unmatched data
\item \code{pairs}: Column pairing information
\item \code{compare_type}: Results from type comparison (if enabled)
\item \code{compare_values}: Results from value comparison (if enabled)
\item \code{extract_diff_values}: Extracted differences (if enabled)
\item \code{interactive}: Whether interactive mode is enabled
}
Returns \code{NULL} invisibly if the two datasets are identical.
}
\description{
\code{myrror} provides tools for comparing data frames, identifying differences,
and extracting summary tables or lists of differences.
}
\examples{


# 1. Specifying by, by.x or by.y:
myrror(survey_data, survey_data_2, by=c('country', 'year'))

## These are equivalent:
myrror(survey_data, survey_data_2_cap, by.x=c('country', 'year'), by.y = c('COUNTRY', 'YEAR'))
myrror(survey_data, survey_data_2_cap, by=c('country' = 'COUNTRY', 'year' = 'YEAR'))

# 2. Turn off interactivity:
myrror(survey_data, survey_data_2, by=c('country', 'year'), interactive = FALSE)

# 3. Turn off factor_to_char (it will treat factors as factors):
myrror(survey_data, survey_data_2, by=c('country', 'year'), factor_to_char = FALSE)

# 4. Turn off compare_type:
myrror(survey_data, survey_data_2, by=c('country', 'year'), compare_type = FALSE)
## Same can be done for compare_values and extract_diff_values.

# 5. Set tolerance:
myrror(survey_data, survey_data_2, by=c('country', 'year'), tolerance = 1e-5)

}
\references{
https://pip-technical-team.github.io/myrror/
}
\seealso{
Useful links:
\itemize{
  \item \url{https://pip-technical-team.github.io/myrror/}
  \item \url{https://github.com/PIP-Technical-Team/myrror}
  \item Report bugs at \url{https://github.com/PIP-Technical-Team/myrror/issues}
}

}
\author{
\strong{Maintainer}: R.Andres Castaneda \email{acastanedaa@worldbank.org}

Authors:
\itemize{
  \item Giorgia Cecchinato \email{gcecchinato@worldbank.org}
  \item Rossana Tatulli \email{rtatulli@worldbank.org}
}

Other contributors:
\itemize{
  \item Global Poverty and Inequality Data Team World Bank [copyright holder]
}

}
\keyword{package}
