% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.R
\name{ndate}
\alias{ndate}
\title{neat representation of dates}
\usage{
ndate(date, display_weekday = TRUE, is_month = FALSE)
}
\arguments{
\item{date}{a Date or POSIX time stamp}

\item{display_weekday}{a Boolean. Whether the weekday of the date
to be included.}

\item{is_month}{a Boolean variable representing if the date represents month.
If this set to TRUE,
the function returns 'MMMM'YY' as the output which is a neater
representation of month.}
}
\value{
String representation of the date
}
\description{
neat representation of dates
}
\examples{
# Neat representation of current date
x <- Sys.Date()
ndate(x)
# Neat representation of current date with day of week.
ndate(x, display_weekday = FALSE)
# Neat representation of current date with only month and year
ndate(x, display_weekday = FALSE, is_month = TRUE)
}
