% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src.R
\name{ntimestamp}
\alias{ntimestamp}
\title{neat representation of time stamp}
\usage{
ntimestamp(
  timestamp,
  display_weekday = TRUE,
  include_date = TRUE,
  include_hours = TRUE,
  include_minutes = TRUE,
  include_seconds = TRUE,
  include_timezone = TRUE
)
}
\arguments{
\item{timestamp}{a POSIX time stamp}

\item{display_weekday}{a Boolean representing if the weekday of the timestamp
to be included. By default it is set to TRUE}

\item{include_date}{a Boolean representing if the date of time stamp
to be included. By default it is set to TRUE.}

\item{include_hours}{a Boolean representing if the hours to be included.
By default it is set to TRUE}

\item{include_minutes}{a Boolean representing if the minutes to be included.
By default it is set to TRUE}

\item{include_seconds}{a Boolean representing if the seconds to be included.
By default it is set to TRUE}

\item{include_timezone}{a Boolean variable representing if the
timezone of the date variable to be included. By default it is set to TRUE.}
}
\value{
String representation of time stamp
}
\description{
neat representation of time stamp
}
\examples{
# Neat representation of time stamp
x <- Sys.time()
ntimestamp(x)
# Neat representation of time from a time stamp
ntimestamp(x, include_date = FALSE, include_seconds = FALSE,
include_timezone = FALSE)
}
