% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brms_custom.R
\name{brms_custom_family}
\alias{brms_custom_family}
\title{Neo-normal as custom distribution family in brms}
\usage{
brms_custom_family(family = "msnburr", vectorize = TRUE)
}
\arguments{
\item{family}{distribution neo-normal option: "msnburr", "msnburr2a", "gmsnburr", "jfst", and "fossep"}

\item{vectorize}{logical; if TRUE,  Stan code of family distribution is vectorize 
The default value of this parameter is TRUE}
}
\value{
custom_family is an object of class custom family of brms and stanvars_family is stanvars object (the Stan code of function of neo-normal distributions (lpdf,cdf,lcdf,lccdf,quantile and rng))
}
\description{
Neo-normal as custom distribution family in brms
}
\examples{
\dontrun{
  library(brms)
  library(neodistr)
  x<-runif(100)
  e<-rmsnburr(100,0,1,0.8)
  y<-0.5+0.8*x+e
  data<-data.frame(y,x)
  msnburr<-brms_custom_family("msnburr")
  fit <- brm(
    y ~ x, data = data,
    family = msnburr$custom_family, stanvars = msnburr$stanvars_family,
    prior=c(set_prior("cauchy(0,5)",class="alpha"),set_prior("cauchy(0,1)",class="sigma"))
  )
  summary(fit)
  pp <- posterior_predict(fit)
  ppe <- posterior_epred(fit)
  loo(fit)
  }
}
\author{
Achmad Syahrul Choir
}
