% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_dist.R
\name{summary_dist}
\alias{summary_dist}
\title{Summaries of Neo-normal Distribution}
\usage{
summary_dist(family = "msnburr", par = c(mu = 0, sigma = 1, alpha = 1))
}
\arguments{
\item{family}{identify the type of Neo-normal distribution to be used. There are five categories of neo-normal distributions,
which encompass "msnburr" for MSNBurr , "msnburr2a" for MSNBurr-IIa, "gmsnburr" for GMSNBurr, "jfst" for Jones-Faddy's Skew-t Distribution, "fossep" for Fernandez-Osiewalski-Steel Skew Exponential Power Distribution, and "jsep" for Jones's Skew Exponential Power. 
The default value of this parameter is  "msnburr"}

\item{par}{list values of each parameter, based on the chosen distribution. The default value is "par=c(alpha=1,mu=0,sigma=1)" for MSNBurr parameter
parameter of MSNBurr and MSNBurr-IIa are mu, sigma, alpha
parameter of GMSNBurr, JFST, FOSSEP, and JSEP are mu, sigma, alpha, beta}
}
\value{
media, mean, mode,  variance, skewness, and excess kurtosis of neo-normal distributions
}
\description{
To display a summary of calculations for a specific neo-normal distribution, 
including the mean,median, mode, variance, skewness, and excess.kurtosis.
}
\examples{
summary_dist (family="msnburr2a", par=c(mu=0,sigma=1,alpha=4))

}
\references{
Choir, A. S. (2020). The New Neo-Normal Distributions and their Properties. Dissertation. Institut Teknologi Sepuluh Nopember.
Jones, M.C. and Faddy, M. J. (2003) A skew extension of the t distribution, with applications. Journal of the Royal Statistical Society, Series B, 65, pp 159-174
Rigby, R.A. and Stasinopoulos, M.D. and Heller, G.Z. and De Bastiani, F. 
(2020) Distributions for Modeling Location, Scale, and Shape: 
Using GAMLSS in R.CRC Press
Fernandez, C., Osiewalski, J., & Steel, M. F. (1995) Modeling and inference with v-spherical distributions. 
Journal of the American Statistical Association, 90(432), pp 1331-1340
}
\author{
Achmad Syahrul Choir
}
