% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{npe_download}
\alias{npe_download}
\title{Data downloader}
\usage{
npe_download(
  sites = "JORN",
  dpID = NA,
  token = NA,
  verbose = TRUE,
  product = "plant_diversity",
  ...
)
}
\arguments{
\item{sites}{a vector of NEON site abbreviations. Defaults to "JORN"}

\item{dpID}{if you need a data product not given as one of the product
options, set the data product ID here (e.g. "DP1.10023.001").}

\item{token}{a token from neonscience.org}

\item{verbose}{if true, prints which sites are being downloaded}

\item{product}{a plain language vector of the data product to be downloaded.
Can be "plant_diversity", "litterfall", "woody_veg_structure",
"belowground_biomass", "herbaceous_clip", "coarse_downed_wood",
or "soil_microbe_biomass"}

\item{...}{additional arguments can be passed to neonUtilities::loadByProduct
see ?neonUtilites::loadByProduct for more details}
}
\value{
a list
}
\description{
A wrapper function to download data from the NEON API using neonUtilities::loadByProduct.
Some commonly used
products are provided as plain language options, otherwise the user
can enter the product ID number (dpID). Downloads Plant Presence and Percent
Cover by default (DP1.10058.001).
}
\examples{
\donttest{diversity_object <- npe_download(sites = "JORN")}
}
\keyword{diversity}
\keyword{download}
\keyword{neon}
