% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neon_products.R
\name{neon_products}
\alias{neon_products}
\title{Table of all NEON Data Products}
\usage{
neon_products(
  api = "https://data.neonscience.org/api/v0",
  .token = Sys.getenv("NEON_TOKEN")
)
}
\arguments{
\item{api}{the URL to the NEON API, leave as default.}

\item{.token}{an authentication token from NEON. A token is not
required but will allow access to a higher number of requests before
rate limiting applies, see
\url{https://data.neonscience.org/data-api/rate-limiting/#api-tokens}.
Note that once files are downloaded once, \code{neonstore} provides persistent
access to them without further interaction required with the API.}
}
\description{
Return a table of all NEON Data Products, including product descriptions
and the productCode needed for \link{neon_download}.
(including list-columns).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

products <- neon_products()

# Or search for a keyword
i <- grepl("bird", products$keywords)
products[i, c("productCode", "productName")]
\dontshow{\}) # examplesIf}
}
\seealso{
\link{neon_download}
}
