% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netcutter.R
\name{nc_eval}
\alias{nc_eval}
\title{Compute co-occurrence probabilities}
\usage{
nc_eval(
  occ_matrix,
  occ_probs,
  terms_of_interest = NULL,
  module_size = 2,
  min_occurrences = 0,
  min_support = 0,
  mc.cores = 1
)
}
\arguments{
\item{occ_matrix}{The original occurrence matrix.}

\item{occ_probs}{The matrix of occurrence probabilities, as computed by
\code{\link[=nc_occ_probs]{nc_occ_probs()}}.}

\item{terms_of_interest}{Vector of column names or indices representing the
terms that should be included in the analysis.}

\item{module_size}{The number of terms that should be tested for
co-occurrence.}

\item{min_occurrences}{Minimum number of occurrences of each term.}

\item{min_support}{Minimum number of occurrences of each module.}

\item{mc.cores}{Number of parallel computations with mclapply() (set to 1 for
serial execution)}
}
\value{
A \code{data.frame} with one row for each valid module, and corresponding
number of co-occurrences and p-value.
}
\description{
The main NetCutter function. It generates p-values for all the co-occurring
modules.
}
\details{
If \code{terms_of_interest} is \code{NULL}, all the terms in \code{occ_matrix} are used. If
it is not null, only modules containing at least one of these terms will be
considered. \code{min_occurrences} and \code{min_support} are still used to further
restrict the list of terms that are considered.
}
\examples{
# Generate an occurrence matrix.
m <- matrix(FALSE, 3, 9, dimnames = list(paste0("ID", 1:3), paste0("gene", 1:9)))
m[1, 1:3] <- m[2, c(1:2, 4:5)] <- m[3, c(1, 6:9)] <- TRUE
# Set the seed using the "L'Ecuyer-CMRG" random number generator.
set.seed(1, "L'Ecuyer-CMRG")
# Compute the occurrence probabilities.
occ_probs <- nc_occ_probs(m, R = 20, S = 50)
# Evaluate the co-occurrences of pairs of terms and their statistical significance.
nc_eval(m, occ_probs, module_size = 2)
# Now evaluate triples; no need to recompute the occurrence probabilities.
nc_eval(m, occ_probs, module_size = 3)
# Now consider only modules involving gene1 or gene2.
nc_eval(m, occ_probs, module_size = 2, terms_of_interest = c("gene1", "gene2"))

}
