% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_graph.R
\name{rgraph_ws}
\alias{rgraph_ws}
\alias{small-world}
\title{Watts-Strogatz model}
\usage{
rgraph_ws(
  n,
  k,
  p,
  both.ends = FALSE,
  self = FALSE,
  multiple = FALSE,
  undirected = FALSE
)
}
\arguments{
\item{n}{Integer scalar. Set the size of the graph.}

\item{k}{Integer scalar. Set the initial degree of the ring (must be less than \eqn{n}).}

\item{p}{Numeric scalar/vector of length \eqn{T}. Set the probability of changing an edge.}

\item{both.ends}{Logical scalar. When \code{TRUE} rewires both ends.}

\item{self}{Logical scalar. When \code{TRUE}, allows loops (self edges).}

\item{multiple}{Logical scalar. When \code{TRUE} allows multiple edges.}

\item{undirected}{Logical scalar. Passed to \code{\link{ring_lattice}}}
}
\value{
A random graph of size \eqn{n\times n}{n*n} following the small-world
model. The resulting graph will have \code{attr(graph, "undirected")=FALSE}.
}
\description{
Generates a small-world random graph.
}
\details{
Implemented as in Watts and Strogatz (1998). Starts from an
undirected ring with \eqn{n} vertices all with degree \eqn{k} (so it must
be an even number), and then rewire each edge by setting the endpoint (so
now you treat it as a digraph) randomly any vertex in \eqn{N \setminus {i}}{N \\ {i}}
avoiding multiple links (by default) using the rewiring algorithm described on
the paper.
}
\examples{

library(igraph)
set.seed(7123)
x0 <- graph_from_adjacency_matrix(rgraph_ws(10,2, 0))
x1 <- graph_from_adjacency_matrix(rgraph_ws(10,2, .3))
x2 <- graph_from_adjacency_matrix(rgraph_ws(10,2, 1))

oldpar <- par(no.readonly=TRUE)
par(mfrow=c(1,3))
plot(x0, layout=layout_in_circle, edge.curved=TRUE, main="Regular")
plot(x1, layout=layout_in_circle, edge.curved=TRUE, main="Small-world")
plot(x2, layout=layout_in_circle, edge.curved=TRUE, main="Random")
par(oldpar)

}
\references{
Watts, D. J., & Strogatz, S. H. (1998). Collective dynamics of "small-world"
networks. Nature, 393(6684), 440–2. \doi{10.1038/30918}

Newman, M. E. J. (2003). The Structure and Function of Complex Networks.
SIAM Review, 45(2), 167–256. \doi{10.1137/S003614450342480}
}
\seealso{
Other simulation functions: 
\code{\link{permute_graph}()},
\code{\link{rdiffnet}()},
\code{\link{rewire_graph}()},
\code{\link{rgraph_ba}()},
\code{\link{rgraph_er}()},
\code{\link{ring_lattice}()}
}
\author{
George G. Vega Yon
}
\concept{simulation functions}
