% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netswan.R
\name{swan_closeness}
\alias{swan_closeness}
\title{Impact on closeness when a node is removed}
\usage{
swan_closeness(g)
}
\arguments{
\item{g}{An \code{igraph} object representing the graph to analyze.}
}
\value{
A numeric vector containing the \code{swan_closeness} values for all vertices.
}
\description{
\code{swan_closeness} measures the change in the sum of the inverse of distances between all node pairs
when excluding that node.#'
}
\details{
\code{swan_closeness} measures the impact of a node's removal by computing the change in
the sum of inverse distances between all node pairs.

The code is an adaptation from the NetSwan package that was archived on CRAN.
}
\examples{
library(igraph)
# Example graph (electrical network structure)
elec <- matrix(ncol = 2, byrow = TRUE, c(
  11,1, 11,10, 1,2, 2,3, 2,9,
  3,4, 3,8, 4,5, 5,6, 5,7,
  6,7, 7,8, 8,9, 9,10
))
gra <- graph_from_edgelist(elec, directed = FALSE)

# Compute swan_closeness
f2 <- swan_closeness(gra)

# Compare with betweenness centrality
bet <- betweenness(gra)
reg <- lm(bet ~ f2)
summary(reg)
}
\references{
Lhomme S. (2015). \emph{Analyse spatiale de la structure des réseaux techniques dans un contexte de risques}.
Cybergeo: European Journal of Geography.
}
