% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkFun_LSM.R
\name{sem.net.lsm}
\alias{sem.net.lsm}
\title{Fit a Structural Equation Model (SEM) with both network and non-network data by incorporating network latent positions as variables.}
\usage{
sem.net.lsm(
  model = NULL,
  data = NULL,
  latent.dim = 2,
  ordered = NULL,
  sampling.weights = NULL,
  data.rescale = FALSE,
  netstats.rescale = FALSE,
  group = NULL,
  cluster = NULL,
  constraints = "",
  WLS.V = NULL,
  NACOV = NULL,
  ...
)
}
\arguments{
\item{model}{A model string specified in lavaan model syntax that includes relationships among the network and non-network variables.}

\item{data}{A list containing the data. The list has two named components, "network" and "nonnetwork"; "network" is a list of named adjacency matrices for the network data, and "nonnetwork" is the dataframe of non-network covariates.}

\item{latent.dim}{The number of network latent dimensions to use in extracting latent positions of network nodes.}

\item{ordered}{Parameter same as "ordered" in the lavaan sem() function; whether to treat data as ordinal.}

\item{sampling.weights}{Parameter same as "sampling.weights" in the lavaan sem() function; whether to apply weights to data.}

\item{data.rescale}{TRUE or FALSE, whether to rescale the whole dataset (with restructured network and nonnetwork data) to have mean 0 and standard deviation 1 when fitting it to SEM, default to FALSE.}

\item{netstats.rescale}{TRUE or FALSE, whether to rescale the network statistics to have mean 0 and standard deviation 1, default to FALSE.}

\item{group}{Parameter same as "group" in the lavaan sem() function; whether to fit a multigroup model.}

\item{cluster}{Parameter same as "cluster" in the lavaan sem() function; whether to fit a cluster model.}

\item{constraints}{Parameter same as "constraints" in the lavaan sem() function; whether to apply constraints to the model.}

\item{WLS.V}{Parameter same as "WLS.V" in the lavaan sem() function; whether to use WLS.V estimator.}

\item{NACOV}{Parameter same as "NACOV" in the lavaan sem() function; whether to use NACOV estimator.}

\item{...}{Optional arguments for the sem() function.}
}
\value{
A networksem object containing the updated model specification string with the reconstructed network statistics as variables, a lavaan SEM output object, and a latentnet ergmm object.
}
\description{
Fit a Structural Equation Model (SEM) with both network and non-network data by incorporating network latent positions as variables.
}
\examples{
\donttest{
set.seed(10)
nsamp = 20
net <- ifelse(matrix(rnorm(nsamp^2), nsamp, nsamp) > 1, 1, 0)
mean(net) # density of simulated network
lv1 <- rnorm(nsamp)
lv2 <- rnorm(nsamp)
nonnet <- data.frame(x1 = lv1*0.5 + rnorm(nsamp),
                     x2 = lv1*0.8 + rnorm(nsamp),
                     x3 = lv2*0.5 + rnorm(nsamp),
                     x4 = lv2*0.8 + rnorm(nsamp))

model <-'
  lv1 =~ x1 + x2
  lv2 =~ x3 + x4
  net ~ lv2
  lv1 ~ net + lv2
'
data = list(network = list(net = net), nonnetwork = nonnet)
set.seed(100)
res <- sem.net.lsm(model = model, data = data, latent.dim = 2)
summary(res)
}
}
