% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{as.mask}
\alias{as.mask}
\title{Convert to a LogicalNeuroVol}
\usage{
as.mask(x, indices)
}
\arguments{
\item{x}{the object to binarize}

\item{indices}{the indices to set to TRUE}
}
\value{
A \code{LogicalNeuroVol} object with \code{TRUE} values at the specified \code{indices}.
}
\description{
Convert to a LogicalNeuroVol
}
\examples{
# Create a simple 3D volume with random values
space <- NeuroSpace(c(10,10,10), spacing=c(1,1,1))
vol <- NeuroVol(array(runif(1000), c(10,10,10)), space)

# Create a mask by thresholding (values > 0.5 become TRUE)
mask1 <- as.mask(vol > 0.5)

# Create a mask by specifying indices
indices <- which(vol > 0.8)  # get indices of high values
mask2 <- as.mask(vol, indices)

# Both masks are LogicalNeuroVol objects
identical(class(mask1), class(mask2))
}
