% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R, R/neurospace.R
\name{reorient}
\alias{reorient}
\alias{reorient,NeuroSpace,character-method}
\title{Remap the grid-to-world coordinates mapping of an image.}
\usage{
reorient(x, orient)

\S4method{reorient}{NeuroSpace,character}(x, orient)
}
\arguments{
\item{x}{the object}

\item{orient}{the orientation code indicating the "remapped" axes.}
}
\value{
A reoriented version of \code{x}.
}
\description{
Remap the grid-to-world coordinates mapping of an image.
}
\details{
When \code{x} is a \code{NeuroSpace} object, the \code{orient} argument should be a character vector
of length 3 specifying the desired anatomical orientation using single-letter codes. Each letter represents
an anatomical direction:
\itemize{
  \item First position: "R" (Right) or "L" (Left)
  \item Second position: "A" (Anterior) or "P" (Posterior)
  \item Third position: "S" (Superior) or "I" (Inferior)
}
For example, \code{c("R", "A", "S")} specifies Right-Anterior-Superior orientation, while
\code{c("L", "P", "I")} specifies Left-Posterior-Inferior orientation. The orientation codes
determine how the voxel grid coordinates map to real-world anatomical space.
}
\examples{
# Create a NeuroSpace object in LPI (Left-Posterior-Inferior) orientation
space <- NeuroSpace(c(64, 64, 40), c(2, 2, 2))

# Reorient to RAS (Right-Anterior-Superior) orientation
# Use individual axis codes: "R" for Right, "A" for Anterior, "S" for Superior
space_ras <- reorient(space, c("R", "A", "S"))

# The transformation matrix will be updated to reflect the new orientation
# Original and reoriented spaces will have different coordinate mappings
coords <- c(32, 32, 20)
orig_world <- grid_to_coord(space, coords)
new_world <- grid_to_coord(space_ras, coords)
}
