% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neuroslice.R
\name{mapToColors}
\alias{mapToColors}
\title{Map intensity values to colors}
\usage{
mapToColors(
  imslice,
  col = heat.colors(128, alpha = 1),
  zero_col = "#00000000",
  alpha = 1,
  irange = range(imslice),
  threshold = c(0, 0)
)
}
\arguments{
\item{imslice}{A numeric vector or array of intensities.}

\item{col}{A vector of colors used as a lookup table.}

\item{zero_col}{Color used for exactly-zero intensities (defaults to transparent).}

\item{alpha}{Global alpha multiplier applied to all colors when \code{alpha < 1}.}

\item{irange}{Intensity range used to normalize values before mapping to \code{col}.}

\item{threshold}{Optional length-2 numeric vector. If \code{diff(threshold) > 0},
values within \code{[threshold[1], threshold[2]]} are set to transparent.}
}
\value{
If \code{alpha == 1}, returns a character vector/array of colors.
If \code{alpha < 1}, returns an array with an added RGBA channel (last dimension length 4).
}
\description{
Convert intensity values (e.g., a 2D slice) into a color representation for
plotting and overlays.
}
