% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/pairs.R
\docType{methods}
\name{pairs}
\alias{pairs}
\alias{pairs,CompositionMatrix-method}
\alias{pairs,GroupedComposition-method}
\title{Plot Compositional Data}
\usage{
\S4method{pairs}{CompositionMatrix}(x, margin = NULL, ...)

\S4method{pairs}{GroupedComposition}(x, ..., margin = NULL, color = NULL, symbol = NULL)
}
\arguments{
\item{x}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{margin}{A \code{\link{character}} string or an \code{\link{integer}} giving the index of
the column to be used as the third part of the ternary plots. If \code{NULL}
(the default), marginal compositions will be used (i.e. the geometric mean
of the non-selected parts).}

\item{...}{Further \link[graphics:par]{graphical parameters}.}

\item{color}{A (named) vector of colors (will be mapped to the group names
of \code{object}) or a \code{\link{function}} that when called with a single argument (an
integer specifying the number of colors) returns a vector of colors.}

\item{symbol}{A (named) vector of colors (will be mapped to the group names
of \code{object}).}
}
\value{
\code{plot()} is called for its side-effects: is results in a graphic being
displayed (invisibly return \code{x}).
}
\description{
Displays a matrix of ternary plots.
}
\examples{
## Data from Day et al. 2011
data("kommos", package = "folio") # Coerce to compositional data
kommos <- remove_NA(kommos, margin = 1) # Remove cases with missing values
coda <- as_composition(kommos, parts = 3:8, groups = 1)

## Use ceramic types for grouping
pairs(coda)

## Center and scale ternary plots
pairs(coda, by = NULL, center = TRUE, scale = TRUE)
}
\seealso{
\code{\link[isopleuros:ternary_pairs]{isopleuros::ternary_pairs()}}, \code{\link[isopleuros:ternary_plot]{isopleuros::ternary_plot()}}

Other plot methods: 
\code{\link{as_graph}()},
\code{\link{barplot}()},
\code{\link{boxplot}()},
\code{\link{hist}()},
\code{\link{plot}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
