% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standings_prettify.R
\name{nfl_standings_prettify}
\alias{nfl_standings_prettify}
\title{Compute Pretty NFL Standings Table}
\usage{
nfl_standings_prettify(
  standings,
  ...,
  grp_by = c("div", "conf", "nfl"),
  order_by = c("div_rank", "conf_rank", "draft_rank"),
  reverse = FALSE
)
}
\arguments{
\item{standings}{A table of NFL standings. Usually computed by \code{\link[=nfl_standings]{nfl_standings()}}}

\item{...}{Currently unused. The function errors if objects are passed to
the dots, i.e. when unnamed arguments are provided.}

\item{grp_by}{Group the output table by Division (\code{"div"}),
Conference (\code{"conf"}), or complete league (\code{"nfl"})}

\item{order_by}{Order teams by division rank, conference rank, or draft rank}

\item{reverse}{Teams are sorted by the argument \code{order_by} in ascending order
by default. If \code{reverse} is set to \code{TRUE}, order will be reversed.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
Uses the R package gt to create a pretty html table of NFL standings.
}
\section{Output of below examples}{

\if{html}{\figure{standings_tbl1.png}{options: style="width: 75\%;"}}
\if{html}{\figure{standings_tbl2.png}{options: style="width: 75\%;"}}
}

\examples{
\donttest{
# Calculate standings
s <- nflreadr::load_schedules(2024) |>
  nflseedR::nfl_standings(ranks = "DRAFT")

# Create table
tbl1 <- nfl_standings_prettify(s, grp_by = "conf", order_by = "conf_rank")
tbl2 <- nfl_standings_prettify(s, grp_by = "nfl", order_by = "draft_rank")

# The output of tbl1 and tbl2 is given in the above images.
}
}
