% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngram.R
\name{ngram}
\alias{ngram}
\title{Get n-gram frequencies}
\usage{
ngram(
  phrases,
  corpus = "en",
  year_start = 1800,
  year_end = 2022,
  smoothing = 3,
  case_ins = FALSE,
  aggregate = FALSE,
  count = FALSE,
  drop_parent = FALSE,
  drop_all = FALSE,
  type = FALSE
)
}
\arguments{
\item{phrases}{vector of phrases, with a maximum of 12 items}

\item{corpus}{Google corpus to search (see Details for possible values)}

\item{year_start}{start year, default is 1800. Data available back to 1500.}

\item{year_end}{end year, default is 2008}

\item{smoothing}{smoothing parameter, default is 3}

\item{case_ins}{Logical indicating whether to force a case insensitive search.
Default is \code{FALSE}.}

\item{aggregate}{Sum up the frequencies for ngrams associated with wildcard
or case insensitive searches. Default is \code{FALSE}.}

\item{count}{Default is \code{FALSE}.}

\item{drop_parent}{Drop the parent phrase associated with a wildcard
or case-insensitive search. Default is \code{FALSE}.}

\item{drop_all}{Delete the suffix "(All)" from aggregated case-insensitive
searches. Default is \code{FALSE}.}

\item{type}{Include the Google return type (e.g. NGRAM, NGRAM_COLLECTION,
EXPANSION) from result set. Default is \code{FALSE}.}
}
\value{
\code{ngram} returns an object of class "\code{ngram}",
which is a tidyverse \code{tibble} enriched with attributes reflecting
some of the parameters used in the Ngram Viewer query.
}
\description{
\code{ngram} downloads data from the Google Ngram Viewer website and
returns it in a tibble.
}
\details{
Google generated two datasets drawn from digitised books in the Google
Books collection. One was generated in July 2009, the second in July 2012
and the third in 2019. Google is expected to update these datasets as book
scanning continues.

This function provides the annual frequency of words or phrases, known
as n-grams, in a sub-collection or "corpus" taken from the Google Books
collection.The search across the corpus is case-sensitive.

If the function is unable to retrieve data from the Google Ngram Viewer
site (either because of access issues or if the format of Google's site
has changed) a NULL result is returned and messages are printed to the
console but no errors or warnings are raised (this is to align with
CRAN package policies).

Below is a list of available corpora. Note that the data for the 2012
corpuses only extends to 2009.
\tabular{ll}{
\bold{Corpus} \tab \bold{Corpus Name}\cr
en-US-2019\tab American English 2019\cr
en-US-2012\tab American English 2012\cr
en-US-2009\tab American English 2009\cr
en-GB-2019\tab British English 2019\cr
en-GB-2012\tab British English 2012\cr
en-GB-2009\tab British English 2009\cr
zh-Hans-2019\tab Chinese 2019\cr
zh-Hans-2012\tab Chinese 2012\cr
zh-Hans-2009\tab Chinese 2009\cr
en-2019\tab English 2019\cr
en-2012\tab English 2012\cr
en-2009\tab English 2009\cr
en-fiction-2019\tab English Fiction 2019\cr
en-fiction-2012\tab English Fiction 2012\cr
en-fiction-2009\tab English Fiction 2009\cr
en-1M-2009\tab English One Million\cr
fr-2019\tab French 2019\cr
fr-2012\tab French 2012\cr
fr-2009\tab French 2009\cr
de-2019\tab German 2019\cr
de-2012\tab German 2012\cr
de-2009\tab German 2009\cr
iw-2019\tab Hebrew 2019\cr
iw-2012\tab Hebrew 2012\cr
iw-2009\tab Hebrew 2009\cr
es-2019\tab Spanish 2019\cr
es-2012\tab Spanish 2012\cr
es-2009\tab Spanish 2009\cr
ru-2019\tab Russian 2019\cr
ru-2012\tab Russian 2012\cr
ru-2009\tab Russian 2009\cr
it-2019\tab Italian 2019\cr
it-2012\tab Italian 2012\cr
}

The Google Million is a sub-collection of Google Books. All are in
English with dates ranging from 1500 to 2008.
No more than about 6,000 books were chosen from any one year, which
means that all of the scanned books from early years are present,
and books from later years are randomly sampled. The random samplings
reflect the subject distributions for the year (so there are more
computer books in 2000 than 1980).

See \url{http://books.google.com/ngrams/info} for the full Ngram syntax.
}
\examples{
\donttest{ngram(c("mouse", "rat"), year_start = 1950)
ngram(c("blue_ADJ", "red_ADJ"))
ngram(c("_START_ President Roosevelt", "_START_ President Truman"), year_start = 1920)
}
}
