% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/niche.plot.R
\name{niche.plot}
\alias{niche.plot}
\title{Plot for 2-d projection of niche regions.}
\usage{
niche.plot(
  niche.par,
  niche.data,
  alpha = 0.95,
  species.names,
  iso.names,
  lims,
  col,
  ndens = 512,
  pfrac = 0,
  xlab,
  legend = TRUE
)
}
\arguments{
\item{niche.par}{A list of length \code{nspecies}, each element of which in turn is a list with elements \code{mu} and \code{Sigma}.  Each of these will correspond to an ellipse being drawn for that species in the corresponding 2-d plane. See 'Example'.}

\item{niche.data}{A list of length \code{nspecies}, each element of which is a matrix with observations along the rows and niche indicators (e.g., stable isotopes) along the columns.}

\item{alpha}{Size of the niche region to plot. Defaults to 0.95.}

\item{species.names}{Names of the species. Defaults to \code{names(niche.par)}.}

\item{iso.names}{Names of the niche indicators (or isotopes) to plot. Defaults to \code{colnames(niche.par)}.}

\item{lims}{Two-row matrix of range limits for each niche indicator.  Defaults to include all ellipses.}

\item{col}{Vector of colours in which each species will be drawn.}

\item{ndens}{Number of points at which to evaluate kernel density estimates.}

\item{pfrac}{Fraction of the plot on which to display 1-dimensional raw niche indicator data. \code{pfrac = 0} means don't display the raw data in 1-d.}

\item{xlab}{Title of plot, located on the bottom.  Defaults to no title.}

\item{legend}{Whether or not to add a legend.  Defaults to \code{TRUE}.}
}
\value{
Returns a series of plots displaying niche indicator data and their probabilistic niche projections.
}
\description{
For one or more species, creates a series of plots: (i) the raw niche indicators (e.g., stable isotope) data, (ii) their density estimates, and (iii) 2-dimensional projections of probabilistic niche regions based on \eqn{n}-dimensionsional data.
}
\details{
A set of plots is created for each pairwise combination of niche indicators.  Below the diagonal are scatterplots for each species, above the diagonal are ellipses corresponding to 2-d projections of the probabilistic niche regions.  The diagonal displays density estimates for each indicator, and optionally the raw 1-d data.  See Swanson et al. (2015) for detailed description of the probabilistic niche region.
}
\examples{
data(fish) # 4 fish, 3 isotopes

# generate 10 parameter draws from the posteriors
# of each fish with default prior
nsamples <- 10
fish.par <- tapply(1:nrow(fish), fish$species,
                   function(ii) niw.post(nsamples = nsamples, X = fish[ii,2:4]))

# format data for plotting function
fish.data <- tapply(1:nrow(fish), fish$species, function(ii) X = fish[ii,2:4])

clrs <- c("black", "red", "blue", "orange") # colors for each species
niche.plot(niche.par = fish.par, niche.data = fish.data, pfrac = .1,
           iso.names = expression(delta^{15}*N, delta^{13}*C, delta^{34}*S),
           col = clrs, xlab = expression("Isotope Ratio (per mille)"))
}
\references{
Swanson, H.K., Lysy, M., Stasko, A.D., Power, M., Johnson, J.D., and Reist, J.D. "A new probabilistic method for quantifying n-dimensional ecological niches and niche overlap." \emph{Ecology: Statistical Reports} 96:2 (2015): 318-324. \doi{10.1890/14-0235.1}.
}
\seealso{
\code{\link[=overlap.plot]{overlap.plot()}}, \code{\link[=niw.post]{niw.post()}}, \code{\link[=niiw.post]{niiw.post()}}.
}
