% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ga.cores.R
\name{ga.sel.tournament}
\alias{ga.sel.tournament}
\title{Tournament selection}
\usage{
ga.sel.tournament(data.pop, npop, nbits)
}
\arguments{
\item{data.pop}{A data.frame containing the current population. The first
nbits columns must be the chromosome (typically coded as 0/1). The data
frame must also contain a column named \code{rank}, where smaller values
indicate better individuals (e.g., rank 1 is best).}

\item{npop}{Integer. Number of individuals to select for the next generation.}

\item{nbits}{Integer. Number of bits (genes) per chromosome; i.e., the number
of columns taken from \code{data.pop} to form the chromosome matrix.}
}
\value{
A matrix of dimension npop x nbits containing the selected
chromosomes for the next generation.
}
\description{
Select individuals for the next generation using tournament selection.
}
\examples{
data.pop <- data.frame(fitness = stats::runif(10), rank = rank(stats::runif(10)))
population <- matrix(sample(0:1, 100, replace = TRUE), nrow = 10)
ga.sel.tournament(data.pop=cbind(as.data.frame(population), data.pop), npop=10, nbits=10)

}
\author{
Zhonghui Huang
}
