% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabu.cores.R
\name{perturb_2bit}
\alias{perturb_2bit}
\title{Apply 2-bit perturbation to escape local optimum}
\usage{
perturb_2bit(prev_string, search.space, max.try = 1000)
}
\arguments{
\item{prev_string}{A named numeric vector representing the current model.}

\item{search.space}{Character, one of "ivbase" or "oralbase".
Default is "ivbase".}

\item{max.try}{Maximum number of attempts to generate a valid perturbed model.}
}
\value{
A \code{list} with two named numeric vectors:
\item{original_neighbor}{raw 2-bit flip (may be invalid)}
\item{validated_neighbor}{validated and usable model code}
}
\description{
Randomly flips two parameters ("2-bit change") in the current model string
to generate a perturbed candidate.
}
\details{
The function returns both:
\itemize{
\item \code{original_neighbor}: the raw 2-bit flip before validation
\item \code{validated_neighbor}: the corrected version after validation
}
This allows downstream functions (e.g. \code{detect_move()}) to identify
which parameters were intentionally changed (primary moves), while still using
a valid model code for evaluation.
}
\examples{
prev <- c(no.cmpt = 2, eta.km = 0, eta.vc = 1,
          eta.vp = 0, eta.vp2 = 0, eta.q = 1,
          eta.q2 = 0, mm = 0, mcorr = 1, rv = 2)
perturb <- perturb_2bit(prev, search.space = "ivbase")
perturb$original_neighbor   # original 2-bit flip
perturb$validated_neighbor  # validated model

}
\author{
Zhonghui Huang
}
