% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBaseline.R
\name{addBaselineLin}
\alias{addBaselineLin}
\title{Add an estimated baseline linear constant}
\usage{
addBaselineLin(ui, effect = "effect", eb = "Eb", time = "time")
}
\arguments{
\item{ui}{rxode2 model}

\item{effect}{the effect variable that will be modeled}

\item{eb}{baseline constant parameter}

\item{time}{the time or other variable used for baseline decay}
}
\value{
model with baseline linear constant
}
\description{
Add an estimated baseline linear constant
}
\examples{
readModelDb("PK_2cmt_no_depot") |>
  addDirectLin() |>
  convertQuad() |>
  addBaselineLin()
}
\seealso{
Other PD: 
\code{\link{addBaseline1exp}()},
\code{\link{addBaselineConst}()},
\code{\link{addBaselineExp}()},
\code{\link{addDirectLin}()},
\code{\link{convertEmax}()},
\code{\link{convertLogLin}()},
\code{\link{convertQuad}()}
}
\author{
Matthew L. Fidler
}
\concept{PD}
