% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MIX_MULTI.loading_helper.R
\name{getMIX_MULTI.loadings}
\alias{getMIX_MULTI.loadings}
\title{Get Factor Loadings for a Mixture Model with MGM as Submodels}
\usage{
getMIX_MULTI.loadings(
  nClass,
  y_model,
  t_var,
  y_var,
  curveFun,
  intrinsic = NULL,
  records
)
}
\arguments{
\item{nClass}{A numeric value to indicate the number of latent classes.}

\item{y_model}{A character string specifying how to fit the longitudinal outcome. Supported values are "LGCM" and
"LCSM". It takes the value passed from `getMIX()`.}

\item{t_var}{t_var A character vector where each element represents a prefix for column names corresponding to the
time variables for the respective longitudinal process. It takes the value passed from `getMIX()`.}

\item{y_var}{A character vector where each element represents a prefix for column names corresponding to the outcome
variables for the respective longitudinal process. It takes the value passed from `getMIX()`.}

\item{curveFun}{The specified functional form of the growth curve. Supported options include: "linear" (or "LIN"),
"quadratic" (or "QUAD"), "negative exponential" (or "EXP"), "Jenss-Bayley" (or "JB"), "bilinear spline" (or "BLS"),
and "nonparametric" (or "NonP"). It takes the value passed from `getMIX()`.}

\item{intrinsic}{A boolean flag for whether an intrinsically nonlinear longitudinal model is built up. It takes the
value passed from `getMIX()`.}

\item{records}{A list of numeric vectors where each vector contains indices of the observed time points for the
respective longitudinal processes. It takes the value passed from `getMIX()`.}
}
\value{
A list containing the specification of definition variables (i.e., individual measurement occasions) and factor
loadings of multivariate longitudinal outcomes.
}
\description{
This function specifies the factor loadings for a mixture model with MGM as submodels. The longitudinal outcomes are fit
by Latent Growth Curve Models or a Latent Change Score Models.
}
\keyword{internal}
