% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSlinp.R
\name{SSlinp}
\alias{SSlinp}
\alias{linp}
\title{self start for linear-plateau function}
\usage{
linp(x, a, b, xs)

SSlinp(x, a, b, xs)
}
\arguments{
\item{x}{input vector}

\item{a}{the intercept}

\item{b}{the slope}

\item{xs}{break-point of transition between linear and plateau}
}
\value{
a numeric vector of the same length as x containing parameter estimates for equation specified

linp: vector of the same length as x using the linear-plateau function
}
\description{
Self starter for linear-plateau function with parameters a (intercept), b (slope), xs (break-point)
}
\details{
This function is linear when \eqn{x < xs: (a + b * x)} and flat (\eqn{asymptote = a + b * xs}) when \eqn{x >= xs}.
}
\examples{
\donttest{
require(ggplot2)
set.seed(123)
x <- 1:30
y <- linp(x, 0, 1, 20) + rnorm(30, 0, 0.5)
dat <- data.frame(x = x, y = y)
fit <- nls(y ~ SSlinp(x, a, b, xs), data = dat)
## plot
ggplot(data = dat, aes(x = x, y = y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit)))
## Confidence intervals
confint(fit)
}

}
\seealso{
package \CRANpkg{segmented}.
}
