% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rqRes.r
\name{chat}
\alias{chat}
\title{Overdispersion metrics for binomial N-mixture models.}
\usage{
chat(umFit, type = "marginal")
}
\arguments{
\item{umFit}{An object of class \link[unmarked]{unmarkedFit} from a model fitted using \link[unmarked]{pcount}.}

\item{type}{The type of metric to compute, one of 'marginal', 'site-sum' or 'observation'.}
}
\value{
An estimate of overdispersion relative to the fitted model.
}
\description{
Computes various types of overdispersion metrics, based on Pearson residuals, for binomial N-mixture models.
}
\examples{
library(unmarked)
data(mallard)
fm.mallard <- pcount(~ 1 ~ 1, unmarkedFramePCount(y = mallard.y), K=100)
chat(fm.mallard, "m")
chat(fm.mallard, "s")
chat(fm.mallard, "o")
}
