% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bins_ss_Preston2009}
\alias{bins_ss_Preston2009}
\title{NMR grouping bins from Preston et al. (2009).}
\format{
A data frame with 5 rows and 5 variables:
\describe{
  \item{number}{Bin number}
  \item{group}{Name of bin group}
  \item{start}{ppm shift range, lower limit}
  \item{stop}{ppm shift range, upper limit}
  \item{description}{Description of the bin group}
}
}
\source{
C. Preston et al. 2009. "Chemical Changes During
6 Years of Decomposition of 11 Litters in Some Canadian Forest Sites.
Part 1. Elemental Composition, Tannins, Phenolics, and Proximate Fractions". Ecosystems.
\doi{10.1007/s10021-009-9266-0}
}
\usage{
bins_ss_Preston2009
}
\description{
NMR grouping bins from  Preston et al. (2009), for solid-state NMR.
(1) alkyl C (0-50);
(2) methoxyl C (50-60);
(3) O-alkyl C (60-93);
(4) di-O-alkyl C (93-112);
(5) aromatic C (112-140);
(6) phenolic C (140-165);
(7) carboxyl C (165-190)
}
\note{
The NMR spectrum can be split into several bins, based on
chemical shift (ppm). Binsets are specific to nuclei and solvents and
by definition are open on the left and closed on the right;
for example, a bin of (0,1) includes 1 but \emph{not} 0.
}
\seealso{
\code{\link{bins_Clemente2012}} \code{\link{bins_Lynch2019}}
\code{\link{bins_Mitchell2018}}
}
\keyword{datasets}
