% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{dist2full}
\alias{dist2full}
\title{Converts a lower triangular distance matrix to a full distance matrix}
\usage{
dist2full(dis)
}
\arguments{
\item{dis}{A lower triangular matrix, 
resulting from the \code{\link[stats]{dist}} 
function in the \code{stats} package}
}
\value{
A square (symmetric) distance matrix with zeroes in the diagonal.
}
\description{
Converts a lower triangular distance matrix to a full distance matrix
with zeroes in the diagonal.
The input is usually the result of the \code{\link[stats]{dist}} function 
in the \code{stats} package.
This function is adapted from Everitt's book 
(\insertCite{everitt:2004;textual}{nnspat})
}
\examples{
#3D data points
n<-3
X<-matrix(runif(3*n),ncol=3)
dst<-dist(X)
dist2full(dst)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[stats]{dist}}
}
\author{
Elvan Ceyhan
}
