% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funsZcell.nnct.pval}
\alias{funsZcell.nnct.pval}
\alias{Zcell.nnct.pval}
\alias{Zcell.nnct.2s}
\alias{Zcell.nnct.ls}
\alias{Zcell.nnct.rs}
\title{\eqn{p}-values for Cell-specific Z Test Statistics for NNCT}
\usage{
Zcell.nnct.pval(zt)

Zcell.nnct.2s(zt)

Zcell.nnct.ls(zt)

Zcell.nnct.rs(zt)
}
\arguments{
\item{zt}{A \eqn{k \times k} matrix of 
the cell-specific \eqn{Z} test statistics}
}
\value{
\code{Zcell.nnct.pval} returns a \eqn{k \times k \times 3} array 
whose 1st entry is the matrix of \eqn{p}-values for the
two-sided alternative, 
2nd entry is the matrix of \eqn{p}-values 
for the left-sided alternative
and 3rd entry is the matrix of \eqn{p}-values 
for the right-sided alternative
\code{Zcell.nnct.2s} returns a \eqn{k \times k} 
matrix of \eqn{p}-values for the two-sided alternative
\code{Zcell.nnct.rs} returns a \eqn{k \times k} 
matrix of \eqn{p}-values for the right-sided alternative
\code{Zcell.nnct.ls} returns a \eqn{k \times k} 
matrix of \eqn{p}-values for the left-sided alternative
}
\description{
Four functions: \code{Zcell.nnct.2s}, \code{Zcell.nnct.rs}, 
\code{Zcell.nnct.ls} and \code{Zcell.nnct.pval}.

These functions yield a contingency table (i.e., a matrix) of 
the \eqn{p}-values for the cell-specific \eqn{Z}
test statistics for the NNCT 
and take the cell-specific \eqn{Z} test statistics 
in matrix form as their argument.
\code{Zcell.nnct.pval} yields an array of size 
\eqn{k \times k \times 3} 
where 1st entry of the array is the matrix of \eqn{p}-values for the
two-sided alternative, 
2nd entry of the array is the matrix of \eqn{p}-values 
for the left-sided alternative
and 3rd entry of the array is the matrix of \eqn{p}-values 
for the right-sided alternative.
And each of \code{Zcell.nnct.2s}, \code{Zcell.nnct.rs} 
and \code{Zcell.nnct.ls} yield a \eqn{k \times k} matrix of 
\eqn{p}-values for the two-sided, 
right-sided and left-sided alternative, respectively. 

The functions \code{Zcell.nnct.2s}, \code{Zcell.nnct.rs} 
and \code{Zcell.nnct.ls} are equivalent to
\code{\link{Zcell.nnct}(...,alt)$p.val} 
where \code{alt="two-sided"}, \code{"greater"} and \code{"less"}, 
respectively, with the appropriate
arguments for the function \code{\link{Zcell.nnct}} 
(see the examples below).

See also 
(\insertCite{dixon:1994,dixon:NNCTEco2002,ceyhan:eest-2010;textual}{nnspat}).
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
TS<-Zcell.nnct(Y,cls)$statistic
TS
pv<-Zcell.nnct.pval(TS)
pv

Zcell.nnct(Y,cls,alt="t")$p.val
Zcell.nnct(Y,cls,alt="l")$p.val
Zcell.nnct(Y,cls,alt="g")$p.val

Zcell.nnct.2s(TS)

Zcell.nnct.ls(TS)

Zcell.nnct.rs(TS)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Zcell.nnct}} and \code{\link{Zcell.nnct.ct}}
}
\author{
Elvan Ceyhan
}
