% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{rself.ref}
\alias{rself.ref}
\title{Generation of Points from Self Correspondence Pattern}
\usage{
rself.ref(n1, n2, c1r, c2r, r0, distribution = c("uniform", "bvnormal"))
}
\arguments{
\item{n1, n2}{Positive integers representing the numbers of points to be generated from the two classes}

\item{c1r, c2r}{Ranges of the squares which constitute the supports of the two classes}

\item{r0}{The radius of attraction which determines the level of self-reflexivity (or self correspondence) in 
both the uniform and bvnormal distributions for the two classes}

\item{distribution}{The argument determining the distribution of each class. Takes on values \code{"uniform"} and
\code{"bvnormal"} (see the description for the details).}
}
\value{
A \code{list} with the elements
\item{pat.type}{\code{"2c"} for the 2-class pattern of self-correspondence of the two classes}
\item{type}{The type of the spatial pattern}
\item{parameters}{The radius of attraction \eqn{r_0} which determines the level of self-correspondence.}
\item{lab}{The class labels of the generated points, it is 1 class 1 or X1 points and 
2 for class 2 or \eqn{X_2} points}
\item{init.cases}{The initial points for class 1 and class 2, one initial point for each class, marked
with a cross in the plot.}
\item{gen.points}{The output set of generated points from the self-correspondence pattern.}
\item{ref.points}{The input set of reference points, it is \code{NULL} for this function.}
\item{desc.pat}{Description of the species correspondence pattern}
\item{mtitle}{The \code{"main"} title for the plot of the point pattern}
\item{num.points}{The number of generated points.}
\item{xlimit,ylimit}{The possible ranges of the \eqn{x}- and \eqn{y}-coordinates of the generated points}
}
\description{
An object of class \code{"SpatPatterns"}.

Generates \eqn{n_1} 2D points from class 1 and  \eqn{n_2} (denoted as \code{n2} as an argument)
2D points from class 2 in such a way that
self-reflexive pairs are more frequent than expected under CSR independence.
  
If \code{distribution="uniform"}, the points from class 1, say \eqn{X_i} are generated as follows: 
\eqn{X_i \stackrel{iid}{\sim} Uniform(S_1)} for \eqn{S_1=(c1r[1],c1r[2])^2} for \eqn{i=1,2,\ldots,n_{1h}}
where \eqn{n_{1h}=\lfloor n_1/2 \rfloor},
and for \eqn{k=n_{1h},+1,\ldots,n_1}, \eqn{X_k=X_{k-n_{1h}}+r (\cos(T_k), \sin(T_k))} where \eqn{r \sim Uniform(0,r_0)}
and \eqn{T_k} are iid \eqn{\sim Uniform(0,2 \pi)}.
Similarly, the points from class 2, say \eqn{Y_j} are generated as follows: 
\eqn{Y_j \stackrel{iid}{\sim} Uniform(S_2)} for \eqn{S_2=(c2r[1],c2r[2])^2} for \eqn{j=1,2,\ldots,n_{2h}} where \eqn{n_{2h}=\lfloor n_2/2\rfloor)},
and for \eqn{l=n_{2h},+1,\ldots,n_2}, \eqn{Y_l=Y_{l-n_{2h}}+r (\cos(T_l), \sin(T_l))} where \eqn{r \sim Uniform(0,r_0)} and
\eqn{T_l \stackrel{iid}{\sim} Uniform(0,2 \pi)}.
This version is the case IV in the article (\insertCite{ceyhan:NNCorrespond2018;textual}{nnspat}).

If \code{distribution="bvnormal"}, the points from class 1, 
say \eqn{X_i} are generated as follows: 
\eqn{X_i \stackrel{iid}{\sim} BVN(CM(S_1),I_{2x})} 
where \eqn{CM(S_1)} is the center of mass of \eqn{S_1} 
and \eqn{I_{2x}} is a \eqn{2 \times 2} matrix with diagonals
equal to \eqn{s_1^2} with \eqn{s_1=(c1r[2]-c1r[1])/3} 
and off-diagonals are 0 for \eqn{i=1,2,\ldots,n_{1h}} 
where \eqn{n_{1h}=\lfloor{n_1/2\rfloor}},
and for \eqn{k=n_{1h}+1,\ldots,n_1}, \eqn{X_k = Z_k+r (\cos(T_k), \sin(T_k))} 
where \eqn{Z_k \sim BVN(X_{k-n_{1h}}, I_2(r_0))}
with \eqn{I_2(r_0)} being the \eqn{2 \times 2} matrix 
with diagonals \eqn{r_0/3} and 0 off-diagonals, \eqn{r \sim Uniform(0,r_0)} and
\eqn{T_k} are iid \eqn{\sim Uniform(0,2 \pi)}.
Similarly, the points from class 2, say \eqn{Y_j} are generated as follows: 
\eqn{Y_j \stackrel{iid}{\sim} BVN(CM(S_2),I_{2y})} 
where \eqn{CM(S_1)} is the center of mass of \eqn{S_1} and 
\eqn{I_{2y}} is a \eqn{2 \times 2} matrix with diagonals
equal to \eqn{s_2^2} with \eqn{s_2=(c2r[2]-c2r[1])/3} and 
off-diagonals are 0 for \eqn{j=1,2,\ldots,n_{2h}} 
where \eqn{n_{2h}=\lfloor n_2/2\rfloor)},
and for \eqn{l=n_{2h},+1,\ldots,n_2}, \eqn{Y_l = W_k+r (\cos(T_l), \sin(T_l))} 
where \eqn{W_l \sim BVN(Y_{l-n_{2h}}, I_2(r_0))}
with \eqn{I_2(r_0)} being the \eqn{2 \times 2} matrix 
with diagonals \eqn{r_0/3} and 0 off-diagonals, \eqn{r \sim Uniform(0,r_0)} and
\eqn{T_l \stackrel{iid}{\sim} Uniform(0,2 \pi)}.

Notice that the classes will be segregated 
if the supports \eqn{S_1} and \eqn{S_2} are separated, with more separation
implying stronger segregation. Furthermore, \eqn{r_0} 
(denoted as \code{r0} as an argument) determines 
the level of self-reflexivity or self correspondence,
i.e., smaller \eqn{r_0} implies a higher level of self correspondence 
and vice versa for higher \eqn{r_0} .

See also (\insertCite{ceyhan:NNCorrespond2018;textual}{nnspat})
and the references therein.
}
\examples{
n1<-50;  #try also n1<-50; n1<-1000;
n2<-50;  #try also n2<-50; n2<-1000;

c1r<-c(0,1) #try also c(0,5/6), C(0,3/4), c(0,2/3)
c2r<-c(0,1) #try also c(1/6,1), c(1/4,1), c(1/3,1)
r0<-1/9 #try also 1/7, 1/8

#data generation
Xdat<-rself.ref(n1,n2,c1r,c2r,r0)
Xdat

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

#data generation (bvnormal)
Xdat<-rself.ref(n1,n2,c1r,c2r,r0,distr="bvnormal")
Xdat

summary(Xdat)
plot(Xdat,asp=1)
plot(Xdat)

}
\seealso{
\code{\link{Zself.ref}} and \code{\link{Xsq.spec.cor}}
}
\author{
Elvan Ceyhan
}
