% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geography.R
\name{lookup_geography}
\alias{lookup_geography}
\title{Look up Geography Codes}
\usage{
lookup_geography(search_term, dataset_id = "NM_1_1", type = NULL)
}
\arguments{
\item{search_term}{Name or partial name to search (e.g., "London", "Manchester")}

\item{dataset_id}{Dataset to search in (default: "NM_1_1")}

\item{type}{Optional geography TYPE code to filter results}
}
\value{
Tibble of matching geographies with codes and names
}
\description{
Search for UK geography codes by name. Returns matching
geographies from local authorities, regions, wards, and other levels.
}
\examples{
\donttest{
lookup_geography("London")
lookup_geography("Manchester")
lookup_geography("Birmingham", type = "TYPE464")  # Local authorities only
}
}
