% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getLambda.R
\name{getLambda}
\alias{getLambda}
\title{Get Optimal Lambda value}
\usage{
getLambda(dat, lambda = seq(-10, 10, 1/100), parallel = TRUE)
}
\arguments{
\item{dat}{a data frame containing the variables of numeric or integer vectors.}

\item{lambda}{a vector of values of lambda – default (-10, 10) in steps of 0.01.}

\item{parallel}{perform the computation in parallel, default setting is TRUE.}
}
\value{
a numeric vector
}
\description{
Computes optimal lambda value using \link[MASS]{boxcox} function from the provided data.
}
\examples{
\dontrun{ getLambda(mtcars)}
getLambda(mtcars, parallel = FALSE)
}
\references{
{
Courtney, M. G. R., and Chang, K. C. (2018) Dealing with non-normality: an introduction and step-by-step guide using R. TEST, doi: 10.1111/test.12154.
}
}
