% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_results.R
\name{centiles_bin}
\alias{centiles_bin}
\title{Plot centiles of a fitted GAMLSS model (binomial-type)}
\usage{
centiles_bin(
  model,
  xvar,
  cent = c(0.4, 2, 10, 25, 50, 75, 90, 98, 99.6),
  legend = TRUE,
  ylab = "y",
  xlab = "x",
  main = NULL,
  main.gsub = "@",
  xleg = min(xvar),
  yleg = max(model$y),
  xlim = range(xvar),
  ylim = range(model$y),
  save = FALSE,
  plot = TRUE,
  points = TRUE,
  pch = 15,
  cex = 0.5,
  col = "grey",
  col.centiles = seq_along(cent) + 2,
  lty.centiles = 1,
  lwd.centiles = 1,
  colors = "rainbow",
  ...
)
}
\arguments{
\item{model}{a GAMLSS fitted model, for example the result of \code{\link[=fb_select]{fb_select()}}.}

\item{xvar}{the unique explanatory variable}

\item{cent}{a vector with elements the \% centile values for which the centile curves have to be evaluated}

\item{legend}{whether a legend is required in the plot or not, the default is \code{legent=TRUE}  }

\item{ylab}{the y-variable label}

\item{xlab}{the x-variable label}

\item{main}{the main title here as character. 
              If NULL the default title "centile curves using  NO" (or the relevant distributions name) is shown}

\item{main.gsub}{if the \code{main.gsub} (with default "@") appears in the \code{main} 
                 title then it is substituted with the default title.}

\item{xleg}{position of the legend in the x-axis}

\item{yleg}{position of the legend in the y-axis}

\item{xlim}{the limits of the x-axis}

\item{ylim}{the limits of the y-axis}

\item{save}{whether to save the sample percentages or not with default equal to \code{FALSE}. 
            In this case the sample percentages are printed but are not saved }

\item{plot}{whether to plot the centiles. This option is useful for \code{centile.split} }

\item{points}{whether the data points should be plotted, default is \code{TRUE} for \code{centiles()} and
                \code{FALSE} for \code{centiles.fan()}}

\item{pch}{the character to be used as the default in plotting points see \code{par}}

\item{cex}{size of  character see \code{par}}

\item{col}{plotting colour see \code{par}}

\item{col.centiles}{Plotting colours  for the centile curves}

\item{lty.centiles}{line type for the centile curves}

\item{lwd.centiles}{The line width for the centile curves}

\item{colors}{the different colour schemes to be used for the fan-chart. The following are available 
  \code{c("cm","gray", "rainbow", "heat", "terrain", "topo")},  }

\item{...}{for extra arguments}
}
\value{
No return value, only graphical output.
}
\description{
\code{centiles_bin()} plots centile curves and the sample data for
binomial-type distributions (see \link[gamlss:binom]{gamlss::.gamlss.bi.list}) based on a
fitted \code{GAMLSS} object.
}
\examples{
\donttest{
data("ids_data")

mydata_BB_y14 <- shape_data(
  data       = ids_data,
  age_name   = "age",
  score_name = "y14",
  family     = "BB"
)

mod_BB_y14 <- fb_select(
  data       = mydata_BB_y14,
  age_name   = "age",
  score_name = "shaped_score",
  family     = "BB",
  selcrit    = "BIC"
)

centiles_bin(mod_BB_y14, xvar = age)
}

}
\seealso{
\code{\link[=fb_select]{fb_select()}}
}
