#' conf.R: Utility for notebookutils configuration
#'
#' @noRd
.confEnv <- new.env(parent = emptyenv())

#' Set a config key/value
#'
#' Dummy in-memory implementation for local development.
#'
#' @param key Config key
#' @param value Config value
#' @export
notebookutils.conf.set <- function(key, value) {
  assign(as.character(key), as.character(value), envir = .confEnv)
  invisible(NULL)
}

#' Get a config value
#'
#' Dummy in-memory implementation for local development.
#'
#' @param key Config key
#' @param default Default value when key is missing
#' @export
notebookutils.conf.get <- function(key, default = "") {
  k <- as.character(key)
  if (exists(k, envir = .confEnv, inherits = FALSE)) {
    get(k, envir = .confEnv, inherits = FALSE)
  } else {
    as.character(default)
  }
}
