% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getNotionDatabaseMetadata.R
\name{getNotionDatabaseMetadata}
\alias{getNotionDatabaseMetadata}
\title{Returns the database metadata as a data.frame}
\usage{
getNotionDatabaseMetadata(secret, database, raw = FALSE)
}
\arguments{
\item{secret}{Notion API token}

\item{database}{Notion database ID}

\item{raw}{if TRUE will not flatten into a data.frame}
}
\value{
data.frame
}
\description{
Retrieve a database's metadata as referenced in Notion API: https://developers.notion.com/reference/get-database
}
\examples{
\dontrun{
my_db <- "database_id"
my_secret <- "NOTION API Secret"

my_db_data <- get_database_metadata(secret = my_secret, database = my_db)
}

}
\author{
Eduardo Flores
}
