% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exp_save_last_plot.R
\name{save_last_plot}
\alias{save_last_plot}
\title{Save the most recent plot to a file}
\usage{
save_last_plot(
  filename = stop("A save path and filename must be specified."),
  size = "4 x 3 in",
  dpi = 300,
  ...
)
}
\arguments{
\item{filename}{(Character) The path and filename of the file to create.}

\item{size}{(Character) The output size of the file, in the form \verb{"width x height unit}. For example:
- \code{"5 x 7 in"}
- \code{"12 x 8 cm"}
- \code{"300 x 150 mm"}
- \code{"1920 x 1080 px"}}

\item{dpi}{(Integer) The resolution (dots per inch) of the output file.}

\item{...}{Other arguments passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}
}
\value{
This function returns nothing, but has the side-effect of writing a file to \code{filename}.
}
\description{
Save the most recent plot to a file
}
\examples{
\donttest{
# Coding matrices included with the package
path_to_matrices <- system.file("insect_study/matrices/", package = "novelqualcodes")

# Import the data
my_matrices    <- import_coding_matrices(path_to_matrices)

# Score novel and duplicate codes
my_scores <- score_codes(my_matrices)

# Generate a plot with no refinements
plot_richness(score_df = my_scores)

# Save it to a temporary directory
save_last_plot(file.path(tempdir(), "test_plot.png"), size = "4 x 3 in")

# Open the temporary directory (if session is running interactively)
if (interactive()) { utils::browseURL(tempdir()) }
}

}
\seealso{
\code{\link[=plot_novelty]{plot_novelty()}}, \code{\link[=plot_richness]{plot_richness()}}
}
