% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oxy-n2pwr.NPH.R
\name{n2pwr.NPH}
\alias{n2pwr.NPH}
\title{Power Calculation with Combination Test}
\usage{
n2pwr.NPH(
  method = "MaxLR",
  entry = 1,
  fup = 1,
  maxfup = entry + fup,
  CtrlHaz,
  hazR,
  transP1,
  transP0,
  Wlist,
  entry_pdf0 = function(x) {
     (1/entry) * (x >= 0 & x <= entry)
 },
  entry_pdf1 = entry_pdf0,
  eventN = NULL,
  totalN = NULL,
  ratio = 1,
  alpha = 0.05,
  alternative = c("two.sided"),
  k = 100,
  nreps = 10
)
}
\arguments{
\item{method}{a text specifying the calculation method, either
\code{"MaxLR"} or \code{"Projection"}. Maximum weighted
logrank test is used if \code{"MaxLR"} is specified; otherwise,
projection test is used.}

\item{entry}{a numeric value indicating the enrollment time, Default: 1}

\item{fup}{a numeric value indicating the minimum follow-up time for subjects.
, Default: 1}

\item{maxfup}{maximum follow-up time}

\item{CtrlHaz}{a function,  specifying the hazard function for control group.}

\item{hazR}{a function, specifying the hazard ratio function between
treatment and control group}

\item{transP1}{a numeric vector of length 2, consisting of the transition
probability from
receiving treatment to drop-out (drop-out rate) and
from receiving treatment to receiving control (drop-in rate) per time unit.}

\item{transP0}{a numeric vector of length 2, consisting of the transition
probability from
receiving control to drop-out (drop-out rate) and
from receiving control to receiving treatment (drop-in rate) per time unit.}

\item{Wlist}{a list, consisting of weight functions applied to the test.
The element of the list must be functions. Default is a list of one constant
function, corresponding to the logrank test.}

\item{entry_pdf0}{a function, indicating the probability density function (pdf)
of enrollment/entry time for control group. The default assumes a uniform distribution
corresponding to the constant enrollment rate.}

\item{entry_pdf1}{a pdf function of enrollment/entry time for treatment}

\item{eventN}{the number of events}

\item{totalN}{the number of subjects}

\item{ratio}{allocation ratio, Default: 1}

\item{alpha}{type i error, Default: 0.05}

\item{alternative}{alternative hypothesis - one of c(\code{"two.sided", "less", "greater"}),
Default: \code{"two.sided"}}

\item{k}{an integer, indicating number of sub-intervals per time unit, Default: 100}

\item{nreps}{number of replicates used for calculating quantitle
using multivariate normal}
}
\value{
a list of components:
\item{power}{asymptotic power }
\item{inN}{a vector consisting of the input of \code{eventN} and \code{totalN}}
\item{outN}{a vector including the output of number of events
and total sample. See details. }
\item{prob_event}{event probability at the end of trial}
\item{L_trans}{a list, consisting of transition matrix at each interval}
\item{pdat}{ a data frame including all the intermediate variables in the calculation.
}
\item{studytime}{a vector of length 2, including the entry and follow-up time as input}
\item{RandomizationRatio}{as input}
}
\description{
\code{n2pwr.NPH} calculates the power given either the
number of events or number of subjects using combination test
}
\details{
Function \code{npwr.NPH} calculates the asymptotic power given number
of events or number of subjects using maximum weighted logrank test or
projection type test. If only \code{eventN} is provided, the
asymptotic power is based on provided number of events. If
only \code{totalN} is given, the pooled event probability (\eqn{eprob}) is calculated
according input design parameters including entry time, follow-up time
and hazard functions, etc. The number of events is calculated as
\code{totalN}*\eqn{eprob}, which is given in returned vector \code{outN}.
Similarly, if only \code{eventN} is given, the total sample
size is given as \code{eventN}/\eqn{eprob}. However, if both
\code{eventN} and \code{totalN} are provided, we only use
\code{eventN} for calculation.
Check function \code{pwr2n.NPH} for more calculation details.
}
\examples{
# entry time
t_enrl <- 12
# follow-up time
t_fup <- 18
# baseline hazard
lmd0 <- -log(0.2)/10
# delayed treatment effects
f_hr_delay <- function(x){(x<=6)+(x>6)*0.75}
# maxcombo test
maxc <- gen.wgt(method="Maxcombo")
pwr1 <- n2pwr.NPH(entry   = t_enrl
                 ,fup      = t_fup
                 ,CtrlHaz = function(x){x^0*lmd0}
                 ,hazR = f_hr_delay
                 ,transP1 = c(0,0)
                 ,transP0 = c(0,0)
                 ,Wlist = maxc
                 ,eventN = 50 # targeted number of events
)
}
\seealso{
\code{\link{pwr2n.NPH}}
}
