% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npi_results_s3.R
\name{npi_flatten.npi_results}
\alias{npi_flatten.npi_results}
\title{Flatten NPI search results}
\usage{
\method{npi_flatten}{npi_results}(df, cols = NULL, key = "npi")
}
\arguments{
\item{df}{A data frame containing the results of a call to
\code{\link{npi_search}}.}

\item{cols}{If non-NULL, only the named columns specified here will be be
flattened and returned along with \code{npi}.}

\item{key}{A quoted column name from \code{df} to use as a matching key. The
default value is \code{"npi"}.}
}
\value{
A data frame (tibble) with flattened list columns.
}
\description{
This function takes an \code{npi_results} S3 object returned by
\code{\link{npi_search}} and flattens its list columns. It unnests the
lists columns and left joins them by \code{npi}. You can optionally specify
which columns from \code{df} to include.
}
\details{
The names of unnested columns are prefixed by the name of their
originating list column to avoid name clashes and show their lineage. List
columns containing all NULL data will be absent from the result because there
are no columns to unnest.
}
\examples{
# Flatten all list columns
data(npis)
npi_flatten(npis)

# Only flatten specified columns
npi_flatten(npis, cols = c("basic", "identifiers"))
}
