#' HSCT dataset
#'
#' This dataset consists of 20 patients with hematologicmalignancies who had allogeneic hematopoietic stem cell transplantation (HSCT) between 2006 and 2009 at the National Institutes of Health (NIH).
#' The variables are as follows:
#'
#' \itemize{
#'   \item ID.      Subject ID
#'   \item Days.    Subject's study visit time relative to time of transplant (day 0)
#'   \item Granu.   Granulocytes (K/uL)
#'   \item LYM.     Lymphocytes (K/uL)
#'   \item MON.     Monocytes (K/uL)
#'    \item G-CSF.   Granulocyte colony-stimulating factor level (pg/mL)
#'    \item IL-15.   IL-15 level (pg/mL)
#'    \item MCP-1.   monocyte chemotactic protein-1 level (pg/mL)
#' }
#'
#' @docType data
#' @keywords datasets
#' @name HSCT
#' @usage data(HSCT)
#' @format A data frame with 271 rows and 8 variables.
#' @references Melenhorst, J.J., Tian, X., Xu, D., Sandler, N.G., Scheinberg, P., Biancotto, A., et al. Cytopenia and leukocyte recovery shape cytokine fluctuations after myeloablative allogeneic hematopoietic stem cell transplantation. Haematologica, 97(6):867-73, 2012.
"HSCT"
