% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npregderiv.R
\docType{package}
\name{npregderiv package}
\alias{npregderiv package}
\title{The package "Nonparametric Estimation of the Derivatives of a Regression Function" implements the method of Wang and Lin (2015) of estimating the first and
second derivatives of a regression function from the original data in the case of an increasing evenly spaced design. The derivative estimates are computed at the design points.
The computations are based on the difference quotients. The package also includes the experimental data set on the deflection measurements of a round substrate before and after the thin
film deposition. See more details regarding the experiment and data analysis in the article of Savchuk and Volinsky (2020).}
\description{
Estimating the first and second derivatives by the method of Wang and Lin (2015) requires choosing the soothing parameter \eqn{k} that shows how many observations from each side of
an estimation point are used. Notice that the method of Wang and Lin (2015) requires an estimation point to be one of the design points. If a single value of \eqn{k} is used for all
estimation points, it is impossible to compute a derivative estimate for the first and the last \eqn{k} data points that constitute the left and right boundary regions, respectively.
Generally, an adaptive value of \eqn{k} may be used (see Wang and Lin (2015)). Even though the article of Wang and Lin (2015) contains the expressions for the asymptotically optimal \eqn{k},
those results are of no practical importance since they involve the higher order derivatives of the regression function. Wang and Lin (2015) implement their method for
the values for \eqn{k} ranging from \eqn{0.02n} to \eqn{0.2n}, where \eqn{n} is the sample size. The larger the value of \eqn{k}, the smoother the resulting estimate. However, too large \eqn{k} may lead to
smoothing away certain important features of the function's derivatives. We found that the value of \eqn{k=0.1n} worked reasonably well for estimating the first and second derivatives
of the regression functions in many practical cases.
}
\details{
The function \code{\link{reg_1derivWL}} is developed to estimate the first derivative of the underlying regression function from the original data. The function \code{\link{reg_2derivWL}} is
intended to estimate the function's second derivative. The latter function was used for estimating the second derivatives of the deflection functions in the experiment
described and analyzed in the article of Savchuk and Volinsky (2020). The deflection's second derivative is used to estimate the substrate's curvature and, ultimately, the
residual stress of the thin film deposited on the substrate.

The data set \code{\link{wafer40}} analyzed in the article of Savchuk and Volinsky (2020) is included into the package. It contains the deflection measurements for one of the
wafers (wafer 40) used in the experiment. The measurements are taken before and after the thin film deposition in two radial directions on the round substrate and are marked as
"0 degrees" and "90 degrees" depending on the scan orientation. The design points are separated by 0.000005 m. The resulting sample size in each case is \eqn{n}=7755. All
deflection and position measurements are recorded in meters.
}
\references{
Wang, W.W., Lin, L. (2015) \url{http://www.jmlr.org/papers/v16/wang15b.html} ``Derivative Estimation Based on Difference Sequence via Locally Weighted Least Squares Regression'', \emph{Journal of Machine Learning Research}, 16, 2617-2641.

Savchuk, O., Volinsky, A.A. (2020). ``Nonparametric estimation of SiC film residual stress from the wafer profile''.
}
