% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/np.den.R
\name{bin.den}
\alias{bin.den}
\alias{bin.den-class}
\alias{as.bin.den}
\alias{as.bin.den.data.grid}
\alias{as.bin.den.bin.den}
\title{Linear binning for density estimation}
\usage{
bin.den(x, nbin = NULL)

as.bin.den(object, ...)

\method{as.bin.den}{data.grid}(object, weights.ind = 1, ...)

\method{as.bin.den}{bin.den}(object, ...)
}
\arguments{
\item{x}{vector or matrix of covariates (e.g. spatial coordinates). 
Columns correspond with dimensions and rows with observations.}

\item{nbin}{vector with the number of bins on each dimension.}

\item{object}{(gridded data) used to select a method.}

\item{...}{further arguments passed to or from other methods.}

\item{weights.ind}{integer or character with the index or name of the component 
containing the bin counts/weights.}
}
\value{
Returns an S3 object of \code{\link{class}} \code{bin.den} (extends \code{\link{data.grid}}). 
   A list with the following 3 components:
\item{binw}{vector or array (dimension \code{nbin}) with the bin counts (weights).}
\item{grid}{a \code{\link{grid.par}}-\code{\link{class}} object with the grid parameters.}
\item{data}{a list with a component \code{$x} with argument \code{x}.}
}
\description{
Creates a \code{bin.den}-\code{\link{class}} (gridded binned density) object 
with linear binning counts.
}
\details{
If parameter \code{nbin} is not specified is set to \code{pmax(25, rule.binning(x))}.
}
\examples{
binden <- bin.den(earthquakes[, c("lon", "lat")], nbin = c(30,30))
bindat <- binning(earthquakes[, c("lon", "lat")], earthquakes$mag, nbin = c(30,30))
all.equal(binden, as.bin.den(bindat))
}
\seealso{
\code{\link{np.den}}, \code{\link{h.cv}}, \code{\link{bin.data}}, 
\code{\link{locpol}}, \code{\link{rule.binning}}.
}
