% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trle_cond.R
\name{trle_cond}
\alias{trle_cond}
\title{Count the number of events in a sequence}
\usage{
trle_cond(x, a_op = "gte", a, b_op = "gte", b, isolated = FALSE)
}
\arguments{
\item{x}{numeric vector.}

\item{a_op, b_op}{character. Operator, \code{gte} = greater than or equal, \code{lte} = less than or equal, \code{gt} = greater than, \code{lt} = less than, \code{e} = equal.}

\item{a}{integer. Length of period threshold.}

\item{b}{integer. Value threshold.}

\item{isolated}{logical. Consider only isolated events, i.e. surrounded by zeros. On this case, \code{a} and \code{a_op} are not considered.}
}
\value{
a numeric value.
}
\description{
This function will count the occurrence of sequential events that meets some conditions.
}
\details{
Example: In a vector, how many sequences have at least 3 consecutive observations (\code{a_op = "gte", a = 3}) with values equal or greater than 5 (\code{b_op = "gte", b = 5})?
}
\examples{
# How many sequences have at least 3 consecutive observations with value equal or greater than 5?
trle_cond(x = c(8,15,20,0,0,0,0,5,9,12), a_op = "gte", a = 3, b_op = "gte", b = 5)

}
