% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nppois.R
\name{nppois}
\alias{nppois}
\alias{rnppois}
\alias{dnppois}
\alias{pnppois}
\title{Class \code{nppois}}
\usage{
nppois(v, w=1, grouping=TRUE)
rnppois(n, mix=disc(1), ...)
dnppois(x, mix=disc(1), log=FALSE)
pnppois(x, mix=disc(1), lower.tail=TRUE, log.p=FALSE)
}
\arguments{
\item{v}{a numeric vector that stores the values of a sample.}

\item{w}{a numeric vector that stores the corresponding
weights/frequencies of the observations.}

\item{grouping}{logical, to use frequencies (w) for identical
values}

\item{n}{the sample size.}

\item{x}{an object of class \code{nppois}.}

\item{mix}{an object of class \code{disc}.}

\item{log}{logical, to compute the log-values or not.}

\item{lower.tail, }{=FALSE, if lower.tail values are to be
returned.}

\item{log.p, }{=FALSE, if log probability values are to be
returned.}

\item{...}{arguments passed on to function \code{plot}.}
}
\description{
Class \code{nppois} is used to store data that will
  be processed as those of a nonparametric Poisson mixture.

Function \code{nppois} creates an object of class \code{nppois},
 given values and weights/frequencies.

Function \code{rnppois} generates a random sample from a Poisson
 mixture and saves the data as an object of class \code{nppois}.

Function \code{dnppois} is the density function of a Poisson
 mixture.

Function \code{pnppois} is the distribution function of a Poisson
 mixture.
}
\examples{
mix = disc(pt=c(0,4), pr=c(0.3,0.7))  # a discrete distribution
x = rnppois(200, mix)
dnppois(0:10, mix)
pnppois(0:10, mix)
dnppois(nppois(0:10), mix)
pnppois(nppois(0:10), mix)
 
}
\references{
Wang, Y. (2007). On fast computation of the non-parametric maximum
likelihood estimate of a mixing distribution. \emph{Journal of the
Royal Statistical Society, Ser. B}, \bold{69}, 185-198.
}
\seealso{
\code{\link[lsei]{nnls}}, \code{\link{cnm}},
  \code{\link{cnmms}}, \code{\link{plot.nspmix}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
