% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npnorm.R
\name{plot.npnorm}
\alias{plot.npnorm}
\title{Plotting a Nonparametric or Semiparametric Normal Mixture}
\usage{
\method{plot}{npnorm}(
  x,
  mix,
  beta,
  breaks = NULL,
  col = 2,
  len = 100,
  add = FALSE,
  border.col = NULL,
  border.lwd = 1,
  fill = "lightgrey",
  main,
  lwd = 2,
  lty = 1,
  xlab = "Data",
  ylab = "Density",
  components = c("proportions", "curves", "null"),
  lty.components = 2,
  lwd.components = 2,
  ...
)
}
\arguments{
\item{x}{an object of class \code{npnorm}.}

\item{mix}{an object of class \code{disc}, for a discrete
distribution.}

\item{beta}{the structural parameter.}

\item{breaks}{the rough number bins used for plotting the
histogram.}

\item{col}{the color of the density curve to be plotted.}

\item{len}{the number of points roughly used to plot the density
curve over the interval of length 8 times the component standard
deviation around each component mean.}

\item{add}{if \code{FALSE}, creates a new plot; if \code{TRUE},
adds the plot to the existing one.}

\item{border.col}{color for the border of histogram boxes.}

\item{border.lwd}{line width for the border of histogram boxes.}

\item{fill}{color to fill in the histogram boxes.}

\item{main, lwd, lty, xlab, ylab}{arguments for graphical parameters
(see \code{par}).}

\item{components}{if \code{proportions} (default), also show the
support points and mixing proportions (in proportional vertical
lines); if \code{curves}, also show the component density
curves; if \code{null}, components are not shown.}

\item{lty.components, lwd.components}{line type and width for the
component curves.}

\item{...}{arguments passed on to function \code{plot}.}
}
\description{
Function \code{plot.npnorm} plots the normal mixture.
}
\examples{

mix = disc(pt=c(0,4), pr=c(0.3,0.7))  # a discrete distribution
x = rnpnorm(200, mix, sd=1)
plot(x, mix, beta=1)

}
\references{
Wang, Y. (2007). On fast computation of the non-parametric maximum
likelihood estimate of a mixing distribution. \emph{Journal of the
Royal Statistical Society, Ser. B}, \bold{69}, 185-198.
}
\seealso{
\code{\link[lsei]{nnls}}, \code{\link{cnm}},
  \code{\link{cnmms}}, \code{\link{plot.nspmix}}.
}
\author{
Yong Wang <yongwang@auckland.ac.nz>
}
